/*
 * Decompiled with CFR 0.152.
 */
package org.databene.benerator.primitive.regex;

import org.databene.benerator.Generator;
import org.databene.benerator.primitive.number.adapter.IntegerGenerator;
import org.databene.benerator.wrapper.GeneratorProxy;
import org.databene.model.function.Sequence;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class NFoldCompositeStringGenerator
extends GeneratorProxy<String> {
    private int minCount;
    private int maxcount;
    private Generator<Integer> quantityGenerator;

    public NFoldCompositeStringGenerator(Generator<String> patternGenerator, int minCount, int maxCount) {
        super(patternGenerator);
        this.minCount = minCount;
        this.maxcount = maxCount;
        this.quantityGenerator = new IntegerGenerator(minCount, maxCount, 1, Sequence.RANDOM);
    }

    @Override
    public Class<String> getGeneratedType() {
        return String.class;
    }

    @Override
    public String generate() {
        StringBuilder builder = new StringBuilder();
        int count = this.quantityGenerator.generate();
        for (int i = 0; i < count; ++i) {
            if (!this.source.available()) continue;
            builder.append((String)this.source.generate());
        }
        return builder.toString();
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[source=" + this.source + ", " + this.minCount + "<=partCount<=" + this.maxcount + ']';
    }
}

