/*
 * Decompiled with CFR 0.152.
 */
package org.databene.benerator.primitive.regex;

import java.util.Set;
import org.databene.benerator.Generator;
import org.databene.benerator.primitive.CharacterGenerator;
import org.databene.benerator.primitive.UniqueStringGenerator;
import org.databene.benerator.primitive.regex.NFoldCompositeStringGenerator;
import org.databene.benerator.primitive.regex.RegexStringGenerator;
import org.databene.benerator.primitive.regex.UniqueCompositeStringGenerator;
import org.databene.benerator.sample.ConstantGenerator;
import org.databene.benerator.wrapper.AlternativeGenerator;
import org.databene.benerator.wrapper.ConvertingGenerator;
import org.databene.benerator.wrapper.UniqueAlternativeGenerator;
import org.databene.commons.converter.ToStringConverter;
import org.databene.regex.AlternativePattern;
import org.databene.regex.CharSetPattern;
import org.databene.regex.Group;
import org.databene.regex.Regex;
import org.databene.regex.RegexPart;
import org.databene.regex.SubPattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RegexPartGeneratorFactory {
    RegexPartGeneratorFactory() {
    }

    public static Generator<String> createRegexPartGenerator(RegexPart part, int maxQuantity, boolean unique) {
        SubPattern pattern = part.getPattern();
        int min = part.getQuantifier().getMin();
        int max = part.getQuantifier().getMax();
        if (max == -1) {
            max = Math.max(min, maxQuantity);
        }
        if (pattern instanceof CharSetPattern) {
            return RegexPartGeneratorFactory.createCharSetPatternGenerator(pattern, min, max, unique);
        }
        if (pattern instanceof Group) {
            return RegexPartGeneratorFactory.createGroupGenerator((Group)pattern, min, max, maxQuantity, unique);
        }
        if (pattern instanceof AlternativePattern) {
            return RegexPartGeneratorFactory.createAlternativeGenerator((AlternativePattern)pattern, min, max, maxQuantity, unique);
        }
        throw new UnsupportedOperationException("Unsupported RegexPart type: " + part.getClass().getName());
    }

    public static Generator<String>[] getRegexGenerators(AlternativePattern alternatives, int maxPartLength, boolean unique) {
        Regex[] regexes = alternatives.getPatterns();
        RegexStringGenerator[] sources = new RegexStringGenerator[regexes.length];
        for (int i = 0; i < regexes.length; ++i) {
            sources[i] = new RegexStringGenerator(regexes[i], maxPartLength, unique);
        }
        return sources;
    }

    private static Generator<String> createAlternativeGenerator(AlternativePattern pattern, int min, int max, int maxQuantity, boolean unique) {
        if (unique) {
            if (min == max && min == 1) {
                return new UniqueAlternativeGenerator<String>(String.class, RegexPartGeneratorFactory.getRegexGenerators(pattern, maxQuantity, unique));
            }
            return new UniqueCompositeStringGenerator((SubPattern)pattern, min, max, maxQuantity);
        }
        return new NFoldCompositeStringGenerator(new AlternativeGenerator<String>(String.class, RegexPartGeneratorFactory.getRegexGenerators(pattern, maxQuantity, unique)), min, max);
    }

    private static Generator<String> createGroupGenerator(Group pattern, int min, int max, int maxQuantity, boolean unique) {
        if (unique) {
            return new UniqueCompositeStringGenerator((SubPattern)pattern, min, max, maxQuantity);
        }
        return new NFoldCompositeStringGenerator(new RegexStringGenerator(pattern.getRegex(), maxQuantity, unique), min, max);
    }

    private static Generator<String> createCharSetPatternGenerator(SubPattern pattern, int min, int max, boolean unique) {
        Set charSet = ((CharSetPattern)pattern).getCharSet();
        if (min == max && max == 1 && charSet.size() == 1) {
            return new ConstantGenerator<String>(String.valueOf(charSet.iterator().next()));
        }
        if (unique) {
            return new UniqueStringGenerator(min, max, charSet);
        }
        ConvertingGenerator patternGenerator = new ConvertingGenerator(new CharacterGenerator(((CharSetPattern)pattern).getCharSet()), new ToStringConverter());
        return new NFoldCompositeStringGenerator(patternGenerator, min, max);
    }
}

