/*
 * Decompiled with CFR 0.152.
 */
package org.databene.benerator.primitive.regex;

import java.text.ParseException;
import java.util.Locale;
import org.databene.benerator.Generator;
import org.databene.benerator.InvalidGeneratorSetupException;
import org.databene.benerator.primitive.regex.RegexPartGeneratorFactory;
import org.databene.benerator.sample.ConstantGenerator;
import org.databene.benerator.util.LightweightGenerator;
import org.databene.benerator.wrapper.CompositeArrayGenerator;
import org.databene.benerator.wrapper.MultiGeneratorWrapper;
import org.databene.benerator.wrapper.UniqueCompositeGenerator;
import org.databene.commons.LocaleUtil;
import org.databene.commons.NullSafeComparator;
import org.databene.regex.Regex;
import org.databene.regex.RegexParser;
import org.databene.regex.RegexPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegexStringGenerator
extends LightweightGenerator<String> {
    private String pattern;
    private Regex regex;
    private Locale locale;
    private int maxQuantity;
    private boolean unique;
    private boolean dirty;
    private MultiGeneratorWrapper<String, String[]> partsGenerator;

    public RegexStringGenerator() {
        this(30);
    }

    public RegexStringGenerator(int maxQuantity) {
        this((String)null, maxQuantity);
    }

    public RegexStringGenerator(String pattern) {
        this(pattern, 30);
    }

    public RegexStringGenerator(String pattern, int maxQuantity) {
        this(pattern, LocaleUtil.getFallbackLocale(), maxQuantity);
    }

    public RegexStringGenerator(String pattern, Locale locale, Integer maxQuantity) {
        this(pattern, locale, maxQuantity, false);
    }

    public RegexStringGenerator(String pattern, Locale locale, Integer maxQuantity, boolean unique) {
        this(RegexStringGenerator.parse(pattern, locale), maxQuantity, unique);
        this.partsGenerator = unique ? new UniqueCompositeGenerator<String>(String.class, new Generator[0]) : new CompositeArrayGenerator<String>(String.class, new Generator[0]);
        this.locale = locale;
        this.pattern = pattern;
        this.maxQuantity = maxQuantity != null ? maxQuantity : 30;
        this.unique = unique;
        this.dirty = true;
    }

    public RegexStringGenerator(Regex regex, Integer maxQuantity) {
        this(regex, maxQuantity, false);
    }

    public RegexStringGenerator(Regex regex, Integer maxQuantity, boolean unique) {
        super(String.class);
        this.partsGenerator = unique ? new UniqueCompositeGenerator<String>(String.class, new Generator[0]) : new CompositeArrayGenerator<String>(String.class, new Generator[0]);
        this.regex = regex;
        this.maxQuantity = maxQuantity != null ? maxQuantity : 30;
        this.unique = unique;
        this.dirty = true;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        if (!NullSafeComparator.equals((Object)this.pattern, (Object)pattern)) {
            this.dirty = true;
            this.pattern = pattern;
            this.regex = null;
        }
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.dirty = true;
        this.locale = locale;
    }

    public int getMaxQuantity() {
        return this.maxQuantity;
    }

    public void setMaxQuantity(int maxQuantity) {
        this.dirty = true;
        this.maxQuantity = maxQuantity;
    }

    @Override
    public void validate() {
        if (this.dirty) {
            try {
                if (this.regex == null) {
                    this.regex = RegexStringGenerator.parse(this.pattern, this.locale);
                }
                Generator[] sources = null;
                if (this.regex != null) {
                    RegexPart[] parts = this.regex.getParts();
                    sources = new Generator[parts.length];
                    for (int i = 0; i < parts.length; ++i) {
                        sources[i] = RegexPartGeneratorFactory.createRegexPartGenerator(parts[i], this.maxQuantity, this.unique);
                    }
                    this.partsGenerator.setSources(sources);
                } else {
                    this.partsGenerator.setSources(new ConstantGenerator<String>(null, String.class));
                }
            }
            catch (Exception e) {
                throw new InvalidGeneratorSetupException(e);
            }
            this.dirty = false;
        }
    }

    @Override
    public boolean available() {
        if (this.dirty) {
            this.validate();
        }
        return this.partsGenerator.available();
    }

    @Override
    public String generate() {
        Object[] parts;
        if (this.dirty) {
            this.validate();
        }
        if (this.regex == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        for (Object part : parts = (Object[])this.partsGenerator.generate()) {
            builder.append(part);
        }
        return builder.toString();
    }

    @Override
    public Class<String> getGeneratedType() {
        return String.class;
    }

    @Override
    public void reset() {
        this.partsGenerator.reset();
    }

    @Override
    public void close() {
        this.partsGenerator.close();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + (this.unique ? "unique '" : "'") + this.regex + "']";
    }

    private static Regex parse(String pattern, Locale locale) {
        if (pattern == null) {
            return null;
        }
        try {
            return new RegexParser(locale).parse(pattern);
        }
        catch (ParseException e) {
            throw new InvalidGeneratorSetupException("Invalid pattern: " + pattern, e);
        }
    }
}

