/*
 * Decompiled with CFR 0.152.
 */
package org.databene.benerator.primitive.regex;

import org.databene.benerator.Generator;
import org.databene.benerator.InvalidGeneratorSetupException;
import org.databene.benerator.primitive.regex.RegexPartGeneratorFactory;
import org.databene.benerator.primitive.regex.RegexStringGenerator;
import org.databene.benerator.primitive.regex.UniqueFixedCountCompositeStringGenerator;
import org.databene.benerator.util.SimpleRandom;
import org.databene.benerator.wrapper.UniqueAlternativeGenerator;
import org.databene.regex.AlternativePattern;
import org.databene.regex.Group;
import org.databene.regex.SubPattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UniqueCompositeStringGenerator
implements Generator<String> {
    private SubPattern pattern;
    private int min;
    private int max;
    private Generator<String>[] sources;

    public UniqueCompositeStringGenerator() {
        this(null, 1, 1, 30);
    }

    public UniqueCompositeStringGenerator(SubPattern pattern, int min, int max, int maxQuantity) {
        if (pattern == null) {
            return;
        }
        this.pattern = pattern;
        this.min = min;
        this.max = max;
        this.sources = new Generator[max - min + 1];
        for (int length = min; length <= max; ++length) {
            int j;
            Generator[] subGens;
            if (pattern instanceof AlternativePattern) {
                subGens = new Generator[length];
                for (j = 0; j < length; ++j) {
                    Generator<String>[] altGens = RegexPartGeneratorFactory.getRegexGenerators((AlternativePattern)pattern, maxQuantity, true);
                    subGens[j] = new UniqueAlternativeGenerator<String>(String.class, altGens);
                }
                this.sources[length - min] = new UniqueFixedCountCompositeStringGenerator(subGens);
                continue;
            }
            if (pattern instanceof Group) {
                subGens = new Generator[length];
                for (j = 0; j < length; ++j) {
                    Group group = (Group)pattern;
                    subGens[j] = new RegexStringGenerator(group.getRegex(), maxQuantity, true);
                }
                this.sources[length - min] = new UniqueFixedCountCompositeStringGenerator(subGens);
                continue;
            }
            throw new UnsupportedOperationException("Not a supported pattern: " + pattern);
        }
    }

    @Override
    public Class<String> getGeneratedType() {
        return String.class;
    }

    @Override
    public void validate() {
        if (this.sources == null || this.sources.length == 0) {
            throw new InvalidGeneratorSetupException("sources", "not set");
        }
        for (Generator<String> source : this.sources) {
            source.validate();
        }
    }

    @Override
    public boolean available() {
        for (Generator<String> source : this.sources) {
            if (!source.available()) continue;
            return true;
        }
        return false;
    }

    @Override
    public String generate() {
        int index;
        while (!this.sources[index = SimpleRandom.randomInt(0, this.sources.length - 1)].available()) {
        }
        return this.sources[index].generate();
    }

    @Override
    public void reset() {
        for (Generator<String> source : this.sources) {
            source.reset();
        }
    }

    @Override
    public void close() {
        for (Generator<String> source : this.sources) {
            source.close();
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "['" + this.pattern + ", " + this.min + "<=length<=" + this.max + ']';
    }
}

