/*
 * Decompiled with CFR 0.152.
 */
package org.databene.benerator.sample;

import org.databene.benerator.InvalidGeneratorSetupException;
import org.databene.benerator.util.LightweightGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstantGenerator<E>
extends LightweightGenerator<E> {
    private E value;

    public ConstantGenerator() {
        this((Object)null);
    }

    public ConstantGenerator(E value) {
        this(value, value != null ? value.getClass() : Object.class);
    }

    public ConstantGenerator(E value, Class<E> generatedType) {
        super(generatedType);
        this.value = value;
    }

    public void setValues(E[] value) {
        if (value.length != 0) {
            throw new InvalidGeneratorSetupException("The number of values must be 1 for the " + this.getClass().getSimpleName());
        }
        this.value = value[0];
    }

    public E getValue() {
        return this.value;
    }

    public void setValue(E value) {
        this.value = value;
    }

    @Override
    public E generate() {
        return this.value;
    }

    public String toString() {
        return this.getClass().getSimpleName() + '[' + this.value + ']';
    }
}

