/*
 * Decompiled with CFR 0.152.
 */
package org.databene.benerator.sample;

import java.util.ArrayList;
import org.databene.benerator.Generator;
import org.databene.benerator.sample.SequencedSampleGenerator;
import org.databene.benerator.sample.WeightedSampleGenerator;
import org.databene.benerator.wrapper.GeneratorProxy;
import org.databene.commons.BeanUtil;
import org.databene.model.function.Distribution;
import org.databene.model.function.IndividualWeight;
import org.databene.model.function.Sequence;
import org.databene.model.function.WeightFunction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DistributingGenerator<E>
extends GeneratorProxy<E> {
    private Distribution distribution;
    private String variation1;
    private String variation2;
    private Generator dataProvider;

    public DistributingGenerator(Generator<E> dataProvider, Distribution distribution, String variation1, String variation2) {
        super(null);
        this.dataProvider = dataProvider;
        this.distribution = distribution;
        this.variation1 = variation1;
        this.variation2 = variation2;
    }

    @Override
    public Class<E> getGeneratedType() {
        return this.dataProvider.getGeneratedType();
    }

    @Override
    public void validate() {
        if (this.dirty) {
            ArrayList values = new ArrayList();
            while (this.dataProvider.available()) {
                values.add(this.dataProvider.generate());
            }
            if (this.distribution instanceof Sequence) {
                this.source = new SequencedSampleGenerator(this.dataProvider.getGeneratedType(), (Sequence)this.distribution, values);
            } else if (this.distribution instanceof WeightFunction || this.distribution instanceof IndividualWeight) {
                this.source = new WeightedSampleGenerator(this.dataProvider.getGeneratedType(), this.distribution, values);
            } else {
                throw new UnsupportedOperationException("Distribution type not supported: " + this.distribution.getClass());
            }
            if (this.variation1 != null) {
                BeanUtil.setPropertyValue((Object)this.source, (String)"variation1", (Object)this.variation1, (boolean)false);
            }
            if (this.variation2 != null) {
                BeanUtil.setPropertyValue((Object)this.source, (String)"variation2", (Object)this.variation2, (boolean)false);
            }
            super.validate();
        }
    }

    @Override
    public void reset() {
        super.close();
        this.dataProvider.reset();
        this.dirty = true;
    }
}

