/*
 * Decompiled with CFR 0.152.
 */
package org.databene.benerator.sample;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.databene.benerator.Generator;
import org.databene.benerator.util.GeneratorUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SequenceGenerator<E>
implements Generator<E> {
    private static Log logger = LogFactory.getLog(SequenceGenerator.class);
    private Class<E> productType;
    private E[] values;
    private int cursor = 0;

    public SequenceGenerator(Class<E> productType, E ... values) {
        this.productType = productType;
        this.values = values;
    }

    @Override
    public Class<E> getGeneratedType() {
        return this.productType;
    }

    @Override
    public void validate() {
    }

    @Override
    public boolean available() {
        return this.cursor >= 0;
    }

    @Override
    public E generate() {
        if (this.cursor < 0) {
            throw GeneratorUtil.stateException(this);
        }
        E result = this.values[this.cursor];
        this.cursor = this.cursor < this.values.length - 1 ? ++this.cursor : -1;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("created: " + result));
        }
        return result;
    }

    @Override
    public void reset() {
        this.cursor = 0;
    }

    @Override
    public void close() {
        this.values = null;
        this.cursor = -1;
    }
}

