/*
 * Decompiled with CFR 0.152.
 */
package org.databene.benerator.sample;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import org.databene.benerator.IllegalGeneratorStateException;
import org.databene.benerator.InvalidGeneratorSetupException;
import org.databene.benerator.sample.SequencedSampleGenerator;
import org.databene.benerator.wrapper.GeneratorProxy;
import org.databene.commons.ConversionException;
import org.databene.commons.Converter;
import org.databene.commons.Escalator;
import org.databene.commons.LoggerEscalator;
import org.databene.commons.converter.NoOpConverter;
import org.databene.document.csv.CSVLineIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SequencedCSVSampleGenerator<E>
extends GeneratorProxy<E> {
    private String uri;
    private Converter<String, E> converter;
    private static Escalator escalator = new LoggerEscalator();

    public SequencedCSVSampleGenerator() {
        this((String)null);
    }

    public SequencedCSVSampleGenerator(String uri) {
        this(uri, (Converter<String, E>)new NoOpConverter());
    }

    public SequencedCSVSampleGenerator(Converter<String, E> converter) {
        this(null, converter);
    }

    public SequencedCSVSampleGenerator(String uri, Converter<String, E> converter) {
        super(new SequencedSampleGenerator(converter.getTargetType()));
        this.converter = converter;
        if (uri != null && uri.trim().length() > 0) {
            this.setUri(uri);
        }
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
        this.dirty = true;
    }

    @Deprecated
    public String getUrl() {
        escalator.escalate("The 'url' property is deprecated, use 'uri' instead", this.getClass(), (Object)"getUrl() called");
        return this.getUri();
    }

    @Deprecated
    public void setUrl(String url) {
        escalator.escalate("The 'url' property is deprecated, use 'uri' instead", this.getClass(), (Object)"setUrl() called");
        this.setUri(url);
    }

    void addValue(E value) {
        ((SequencedSampleGenerator)this.source).addValue(value);
    }

    @Override
    public void validate() {
        if (this.dirty) {
            try {
                super.validate();
                if (this.uri == null) {
                    throw new InvalidGeneratorSetupException("uri is not set");
                }
                CSVLineIterator parser = new CSVLineIterator(this.uri);
                ArrayList<Object> samples = new ArrayList<Object>();
                while (parser.hasNext()) {
                    String[] tokens = parser.next();
                    if (tokens.length <= 0) continue;
                    samples.add(this.converter.convert((Object)tokens[0]));
                }
                ((SequencedSampleGenerator)this.source).setValues(samples);
                this.dirty = false;
            }
            catch (FileNotFoundException e) {
                throw new InvalidGeneratorSetupException("uri", "not found: " + this.uri);
            }
            catch (IOException e) {
                throw new IllegalGeneratorStateException(e);
            }
            catch (ConversionException e) {
                throw new InvalidGeneratorSetupException("URI content not valid", e);
            }
        }
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[source=" + this.source + ", converter=" + this.converter + ']';
    }
}

