/*
 * Decompiled with CFR 0.152.
 */
package org.databene.benerator.sample;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.databene.benerator.primitive.number.adapter.IntegerGenerator;
import org.databene.benerator.sample.AbstractSampleGenerator;
import org.databene.benerator.util.SimpleRandom;
import org.databene.model.function.Sequence;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SequencedSampleGenerator<E>
extends AbstractSampleGenerator<E> {
    private List<E> samples = new ArrayList();
    private IntegerGenerator indexGenerator = new IntegerGenerator(0, 0, 1, Sequence.RANDOM);
    private boolean dirty = true;

    public SequencedSampleGenerator() {
        this(null);
    }

    public SequencedSampleGenerator(Class<E> generatedType) {
        this(generatedType, new ArrayList());
    }

    public SequencedSampleGenerator(Class<E> generatedType, E ... values) {
        super(generatedType);
        this.setValues(values);
    }

    public SequencedSampleGenerator(Class<E> generatedType, Sequence distribution, E ... values) {
        super(generatedType);
        this.setDistribution(distribution);
        this.setValues(values);
    }

    public SequencedSampleGenerator(Class<E> generatedType, Collection<E> values) {
        super(generatedType);
        this.setValues(values);
    }

    public SequencedSampleGenerator(Class<E> generatedType, Sequence distribution, Collection<E> values) {
        super(generatedType);
        this.setDistribution(distribution);
        this.setValues(values);
    }

    public Sequence getDistribution() {
        return (Sequence)this.indexGenerator.getDistribution();
    }

    public void setDistribution(Sequence distribution) {
        this.indexGenerator.setDistribution(distribution);
    }

    public Integer getVariation1() {
        return (Integer)this.indexGenerator.getVariation1();
    }

    public void setVariation1(Integer varation1) {
        this.indexGenerator.setVariation1(varation1);
    }

    public Integer getVariation2() {
        return (Integer)this.indexGenerator.getVariation2();
    }

    public void setVariation2(Integer variation2) {
        this.indexGenerator.setVariation2(variation2);
    }

    @Override
    public void addValue(E value) {
        this.samples.add(value);
        this.dirty = true;
    }

    @Override
    public void clear() {
        this.samples.clear();
        this.dirty = true;
    }

    @Override
    public boolean available() {
        return this.indexGenerator.available();
    }

    @Override
    public void validate() {
        if (this.dirty) {
            if (this.samples.size() > 0) {
                this.indexGenerator.setMax(this.samples.size() - 1);
                this.indexGenerator.validate();
            }
            this.dirty = false;
        }
    }

    @Override
    public E generate() {
        if (this.dirty) {
            this.validate();
        }
        if (this.samples.size() == 0) {
            return null;
        }
        int index = (Integer)this.indexGenerator.generate();
        return this.samples.get(index);
    }

    @Override
    public void reset() {
        this.indexGenerator.reset();
    }

    @Override
    public void close() {
        this.indexGenerator.close();
    }

    public static <T> T generate(T ... samples) {
        return samples[SimpleRandom.randomInt(0, samples.length - 1)];
    }

    public static <T> T generate(List<T> samples) {
        return samples.get(SimpleRandom.randomInt(0, samples.size() - 1));
    }

    public String toString() {
        return this.getClass().getSimpleName() + '[' + this.indexGenerator.getDistribution() + ']';
    }
}

