/*
 * Decompiled with CFR 0.152.
 */
package org.databene.benerator.sample;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import org.databene.benerator.Generator;
import org.databene.benerator.IllegalGeneratorStateException;
import org.databene.benerator.InvalidGeneratorSetupException;
import org.databene.benerator.sample.WeightedSample;
import org.databene.benerator.sample.WeightedSampleGenerator;
import org.databene.commons.ConversionException;
import org.databene.commons.Converter;
import org.databene.commons.SystemInfo;
import org.databene.commons.converter.NoOpConverter;
import org.databene.document.csv.CSVLineIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WeightedCSVSampleGenerator<E>
implements Generator<E> {
    private String url;
    private String encoding;
    private Converter<String, E> converter;
    private WeightedSampleGenerator<E> source = new WeightedSampleGenerator();
    private boolean dirty;

    public WeightedCSVSampleGenerator() {
        this(null);
    }

    public WeightedCSVSampleGenerator(String url, String encoding) {
        this(url, encoding, (Converter<String, E>)new NoOpConverter());
    }

    public WeightedCSVSampleGenerator(Converter<String, E> converter) {
        this(null, SystemInfo.getFileEncoding(), converter);
    }

    public WeightedCSVSampleGenerator(String url, String encoding, Converter<String, E> converter) {
        this.converter = converter;
        this.encoding = encoding;
        if (url != null && url.trim().length() > 0) {
            this.setUrl(url);
        }
    }

    public void setUrl(String url) {
        this.url = url;
        this.dirty = true;
    }

    public String getUrl() {
        return this.url;
    }

    @Override
    public Class<E> getGeneratedType() {
        return this.source.getGeneratedType();
    }

    @Override
    public E generate() {
        if (this.dirty) {
            this.validate();
        }
        return this.source.generate();
    }

    @Override
    public void validate() {
        if (this.dirty) {
            try {
                CSVLineIterator iterator = new CSVLineIterator(this.url, ',', this.encoding);
                ArrayList<WeightedSample<Object>> samples = new ArrayList<WeightedSample<Object>>();
                while (iterator.hasNext()) {
                    String[] tokens = iterator.next();
                    if (tokens.length == 0) continue;
                    double weight = tokens.length < 2 ? 1.0 : Double.parseDouble(tokens[1]);
                    Object value = this.converter.convert((Object)tokens[0]);
                    WeightedSample<Object> sample = new WeightedSample<Object>(value, weight);
                    samples.add(sample);
                }
                WeightedSample[] sampleArray = new WeightedSample[samples.size()];
                this.source.setSamples(samples.toArray(sampleArray));
                this.dirty = false;
            }
            catch (FileNotFoundException e) {
                throw new InvalidGeneratorSetupException("url", "not found: " + this.url);
            }
            catch (IOException e) {
                throw new IllegalGeneratorStateException(e);
            }
            catch (ConversionException e) {
                throw new InvalidGeneratorSetupException("URL content not valid", e);
            }
        }
    }

    @Override
    public void reset() {
        this.source.reset();
    }

    @Override
    public void close() {
        this.source.close();
    }

    @Override
    public boolean available() {
        return this.source.available();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[source=" + this.source + ", converter=" + this.converter + ']';
    }
}

