/*
 * Decompiled with CFR 0.152.
 */
package org.databene.benerator.sample;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.databene.benerator.primitive.number.adapter.IntegerGenerator;
import org.databene.benerator.sample.AbstractSampleGenerator;
import org.databene.benerator.sample.WeightedSample;
import org.databene.benerator.util.SimpleRandom;
import org.databene.model.function.Distribution;
import org.databene.model.function.IndividualWeight;
import org.databene.model.function.WeightFunction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WeightedSampleGenerator<E>
extends AbstractSampleGenerator<E> {
    private List<WeightedSample<E>> samples = new ArrayList<WeightedSample<E>>();
    private IndividualWeight<E> individualWeight;
    private IntegerGenerator indexGenerator = new IntegerGenerator(0, 0, 1, new SampleWeightFunction());
    private boolean dirty = true;

    public WeightedSampleGenerator() {
        this(Object.class);
    }

    public WeightedSampleGenerator(Class<E> generatedType) {
        this(generatedType, (Object[])null);
    }

    public WeightedSampleGenerator(Class<E> generatedType, E ... values) {
        super(generatedType);
        this.setValues(values);
    }

    public WeightedSampleGenerator(Class<E> generatedType, Distribution distribution, E ... values) {
        super(generatedType);
        this.setValues(values);
        this.setDistribution(distribution);
    }

    public WeightedSampleGenerator(Class<E> generatedType, Collection<E> values) {
        super(generatedType);
        this.setValues(values);
    }

    public WeightedSampleGenerator(Class<E> generatedType, Distribution distribution, Collection<E> values) {
        super(generatedType);
        this.setValues(values);
        this.setDistribution(distribution);
    }

    public Distribution getDistribution() {
        return this.indexGenerator.getDistribution();
    }

    public void setDistribution(Distribution distribution) {
        if (distribution instanceof IndividualWeight) {
            this.individualWeight = (IndividualWeight)distribution;
        } else {
            this.indexGenerator.setDistribution(distribution);
        }
        this.dirty = true;
    }

    public Integer getVariation1() {
        return (Integer)this.indexGenerator.getVariation1();
    }

    public void setVariation1(Integer varation1) {
        this.indexGenerator.setVariation1(varation1);
        this.dirty = true;
    }

    public Integer getVariation2() {
        return (Integer)this.indexGenerator.getVariation2();
    }

    public void setVariation2(Integer variation2) {
        this.indexGenerator.setVariation2(variation2);
        this.dirty = true;
    }

    public List<WeightedSample<E>> getSamples() {
        return this.samples;
    }

    public void setSamples(WeightedSample<E> ... samples) {
        this.samples.clear();
        for (WeightedSample<E> sample : samples) {
            this.samples.add(sample);
        }
        this.dirty = true;
    }

    public void setSamples(Collection<WeightedSample<E>> samples) {
        this.samples.clear();
        if (samples != null) {
            this.samples.addAll(samples);
        }
        this.dirty = true;
    }

    @Override
    public void addValue(E value) {
        this.samples.add(new WeightedSample<E>(value, 1.0));
        this.dirty = true;
    }

    @Override
    public void clear() {
        this.samples.clear();
    }

    @Override
    public Class<E> getGeneratedType() {
        return this.samples.get(0).getClass();
    }

    @Override
    public void validate() {
        if (this.dirty) {
            if (this.samples.size() > 0) {
                this.normalize();
                this.indexGenerator.setMax(this.samples.size() - 1);
                this.indexGenerator.validate();
            }
            this.dirty = false;
        }
    }

    @Override
    public E generate() {
        if (this.dirty) {
            this.validate();
        }
        if (this.samples.size() == 0) {
            return null;
        }
        int index = (Integer)this.indexGenerator.generate();
        WeightedSample<E> sample = this.samples.get(index);
        return sample.getValue();
    }

    public static <T> T generate(T ... samples) {
        return samples[SimpleRandom.randomInt(0, samples.length - 1)];
    }

    public static <T> T generate(List<T> samples) {
        return samples.get(SimpleRandom.randomInt(0, samples.size() - 1));
    }

    private void normalize() {
        if (this.individualWeight != null) {
            for (WeightedSample<E> sample : this.samples) {
                sample.setWeight(this.individualWeight.weight(sample.getValue()));
            }
        }
        double totalWeight = this.totalWeight();
        for (WeightedSample<E> sample : this.samples) {
            if (totalWeight == 0.0) {
                sample.setWeight(1.0 / (double)this.samples.size());
                continue;
            }
            sample.setWeight(sample.getWeight() / totalWeight);
        }
    }

    private double totalWeight() {
        double total = 0.0;
        for (WeightedSample<E> sample : this.samples) {
            total += sample.getWeight();
        }
        return total;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    private class SampleWeightFunction
    implements WeightFunction {
        private SampleWeightFunction() {
        }

        public double value(double param) {
            return ((WeightedSample)WeightedSampleGenerator.this.samples.get((int)param)).getWeight();
        }

        public String toString() {
            return this.getClass().getSimpleName();
        }
    }
}

