/*
 * Decompiled with CFR 0.152.
 */
package org.databene.benerator.util;

import java.util.ArrayList;
import java.util.List;
import org.databene.benerator.Generator;
import org.databene.benerator.IllegalGeneratorStateException;
import org.databene.commons.ConfigurationError;
import org.databene.commons.StringUtil;
import org.databene.model.data.Entity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeneratorUtil {
    private static final int MAX_SIZE = 100000;

    public static boolean isBeneratorFile(String localFilename) {
        if (StringUtil.isEmpty((String)localFilename)) {
            return false;
        }
        String lcFilename = localFilename.toLowerCase();
        return "benerator.xml".equals(lcFilename) || lcFilename.endsWith(".ben.xml");
    }

    public static <T> IllegalGeneratorStateException stateException(Generator<T> generator) {
        return new IllegalGeneratorStateException("Generator is not available: " + generator);
    }

    public static List<Entity> allProducts(Generator<Entity> generator) {
        ArrayList<Entity> list = new ArrayList<Entity>();
        int count = 0;
        while (generator.available()) {
            list.add(generator.generate());
            if (count++ <= 100000) continue;
            throw new ConfigurationError("Dataset is to large");
        }
        return list;
    }

    public static <T> Class<T> commonTargetTypeOf(Generator<T> ... sources) {
        if (sources.length == 0) {
            return Object.class;
        }
        Class<T> type = sources[0].getGeneratedType();
        for (int i = 1; i < sources.length; ++i) {
            Class<T> tmp = sources[i].getGeneratedType();
            if (!tmp.isAssignableFrom(type)) continue;
            type = tmp;
        }
        return type;
    }
}

