/*
 * Decompiled with CFR 0.152.
 */
package org.databene.benerator.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.databene.benerator.util.SimpleRandom;
import org.databene.commons.IOUtil;
import org.databene.commons.ReaderLineIterator;
import org.databene.commons.StringUtil;
import org.databene.commons.ui.ConsoleInfoPrinter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LineShuffler {
    public static final Log logger = LogFactory.getLog(LineShuffler.class);

    public static void main(String[] args) throws IOException {
        if (args.length < 2) {
            LineShuffler.printHelp();
            System.exit(-1);
        }
        String inFilename = args[0];
        String outFilename = args[1];
        int bufferSize = args.length > 2 ? Integer.parseInt(args[2]) : 100000;
        LineShuffler.shuffle(inFilename, outFilename, bufferSize);
    }

    public static void shuffle(String inFilename, String outFilename, int bufferSize) throws IOException {
        logger.info((Object)("shuffling " + inFilename + " and writing to " + outFilename + " (max. " + bufferSize + " lines)"));
        ReaderLineIterator iterator = new ReaderLineIterator((Reader)new BufferedReader(IOUtil.getReaderForURI((String)inFilename)));
        List<String> lines = LineShuffler.read(bufferSize, iterator);
        LineShuffler.shuffle(lines);
        LineShuffler.save(lines, outFilename);
    }

    public static void shuffle(List<String> lines) {
        int size = lines.size();
        int iterations = size / 2;
        for (int i = 0; i < iterations; ++i) {
            int i2;
            int i1 = SimpleRandom.randomInt(0, size - 1);
            while (i1 == (i2 = SimpleRandom.randomInt(0, size - 1))) {
            }
            String tmp = lines.get(i1);
            lines.set(i1, lines.get(i2));
            lines.set(i2, tmp);
        }
    }

    private static List<String> read(int bufferSize, ReaderLineIterator iterator) {
        ArrayList<String> lines = new ArrayList<String>(Math.max(100000, bufferSize));
        int lineCount = 0;
        while (iterator.hasNext() && lineCount < bufferSize) {
            String line = iterator.next();
            if (StringUtil.isEmpty((String)line)) continue;
            lines.add(line);
            if (++lineCount % 100000 != 99999) continue;
            logger.info((Object)("parsed " + lineCount + " lines"));
        }
        return lines;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void save(List<String> lines, String outputFilename) throws IOException {
        logger.info((Object)("saving " + outputFilename + "..."));
        PrintWriter printer = new PrintWriter(new BufferedWriter(new FileWriter(outputFilename)));
        try {
            for (String line : lines) {
                printer.println(line);
            }
        }
        finally {
            IOUtil.close((Writer)printer);
        }
    }

    private static void printHelp() {
        ConsoleInfoPrinter.printHelp((String[])new String[]{"Parameters: inFile outFile [buffer size]"});
    }
}

