/*
 * Decompiled with CFR 0.152.
 */
package org.databene.benerator.util;

import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleRandom {
    private static Random random = new Random();

    public static long randomLong(long min, long max) {
        if (min > max) {
            throw new IllegalArgumentException("min > max: " + min + " > " + max);
        }
        long range = max - min + 1L;
        long result = range != 0L ? min + random.nextLong() % range : random.nextLong();
        if (result < min) {
            result += range;
        }
        return result;
    }

    public static int randomInt(int min, int max) {
        if (min > max) {
            throw new IllegalArgumentException("min > max: " + min + " > " + max);
        }
        int range = max - min + 1;
        int result = range != 0 ? min + random.nextInt() % range : random.nextInt();
        if (result < min) {
            result += range;
        }
        return result;
    }

    public static <T> T randomValue(T ... values) {
        return values[SimpleRandom.randomInt(0, values.length)];
    }
}

