/*
 * Decompiled with CFR 0.152.
 */
package org.databene.benerator.util;

import java.util.ArrayList;
import java.util.List;
import org.databene.benerator.InvalidGeneratorSetupException;
import org.databene.benerator.util.LightweightGenerator;
import org.databene.benerator.util.SimpleRandom;
import org.databene.commons.TreeModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreePathGenerator
extends LightweightGenerator<List> {
    private TreeModel model;
    private boolean rootIncluded;

    public TreePathGenerator() {
        this((TreeModel)null);
    }

    public TreePathGenerator(TreeModel model) {
        super(List.class);
        this.model = model;
    }

    public boolean isRootIncluded() {
        return this.rootIncluded;
    }

    public void setRootIncluded(boolean rootIncluded) {
        this.rootIncluded = rootIncluded;
    }

    @Override
    public void validate() {
        if (this.model == null) {
            throw new InvalidGeneratorSetupException("model", "is null");
        }
    }

    @Override
    public List generate() {
        ArrayList<Object> path = new ArrayList<Object>();
        Object node = this.model.getRoot();
        if (this.rootIncluded) {
            path.add(node);
        }
        while (this.model.getChildCount(node) > 0) {
            node = this.randomChild(node);
            path.add(node);
        }
        return path;
    }

    private Object randomChild(Object node) {
        int childCount = this.model.getChildCount(node);
        int index = SimpleRandom.randomInt(0, childCount - 1);
        return this.model.getChild(node, index);
    }

    public String toString() {
        return this.getClass().getSimpleName() + '[' + this.model + ']';
    }
}

