/*
 * Decompiled with CFR 0.152.
 */
package org.databene.benerator.util;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.databene.benerator.Generator;
import org.databene.benerator.IllegalGeneratorStateException;
import org.databene.commons.Validator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ValidatingGenerator<P>
implements Generator<P> {
    private static Log logger = LogFactory.getLog(ValidatingGenerator.class);
    public static final int WARNING_THRESHOLD = 100;
    public static final int ERROR_THRESHOLD = 1000;
    protected Validator<P> validator;

    public ValidatingGenerator(Validator<P> validator) {
        this.validator = validator;
    }

    @Override
    public P generate() {
        P product;
        boolean valid;
        int count = 0;
        do {
            product = this.generateImpl();
            valid = this.validator.valid(product);
            if (++count < 1000) continue;
            throw new IllegalGeneratorStateException("Aborting generation, because of 1000 consecutive invalid generations. Validator is: " + this.validator + ". Last attempt was: " + product);
        } while (!valid);
        if (count >= 100) {
            logger.warn((Object)("Inefficient generation: needed " + count + " tries to generate a valid value. "));
        }
        return product;
    }

    protected abstract P generateImpl();
}

