/*
 * Decompiled with CFR 0.152.
 */
package org.databene.benerator.wrapper;

import org.databene.benerator.Generator;
import org.databene.benerator.InvalidGeneratorSetupException;
import org.databene.benerator.primitive.number.adapter.IntegerGenerator;
import org.databene.benerator.wrapper.GeneratorWrapper;
import org.databene.commons.ArrayUtil;
import org.databene.model.function.Distribution;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractArrayGenerator<E, A>
extends GeneratorWrapper<E, A> {
    protected IntegerGenerator sizeGenerator;
    private Class<E> componentType;
    private Class<A> generatedType;

    public AbstractArrayGenerator(Generator<E> source, Class<E> componentType, Class<A> generatedType, int minLength, int maxLength, Distribution distribution) {
        super(source);
        this.componentType = componentType;
        this.generatedType = generatedType;
        this.sizeGenerator = new IntegerGenerator(minLength, maxLength, 1, distribution);
    }

    public long getMinLength() {
        return ((Integer)this.sizeGenerator.getMin()).intValue();
    }

    public void setMinLength(int minLength) {
        this.sizeGenerator.setMin(minLength);
    }

    public long getMaxLength() {
        return ((Integer)this.sizeGenerator.getMin()).intValue();
    }

    public void setMaxLength(int maxLength) {
        this.sizeGenerator.setMax(maxLength);
    }

    public Distribution getLengthDistribution() {
        return this.sizeGenerator.getDistribution();
    }

    public void setLengthDistribution(Distribution distribution) {
        this.sizeGenerator.setDistribution(distribution);
    }

    @Override
    public Class<A> getGeneratedType() {
        return this.generatedType;
    }

    @Override
    public void validate() {
        if (this.dirty) {
            super.validate();
            this.sizeGenerator.validate();
            if (this.source == null) {
                throw new InvalidGeneratorSetupException("source", " is null");
            }
            if (this.generatedType == null) {
                Class<E> cType = this.componentType != null ? this.componentType : this.source.getGeneratedType();
                this.generatedType = ArrayUtil.arrayType(cType);
            }
            this.dirty = false;
        }
    }

    @Override
    public A generate() {
        int length = (Integer)this.sizeGenerator.generate();
        Object[] array = ArrayUtil.newInstance(this.componentType, (int)length);
        for (int i = 0; i < length; ++i) {
            array[i] = this.source.generate();
        }
        return (A)array;
    }
}

