/*
 * Decompiled with CFR 0.152.
 */
package org.databene.benerator.wrapper;

import org.databene.benerator.Generator;
import org.databene.benerator.primitive.number.adapter.IntegerGenerator;
import org.databene.benerator.util.GeneratorUtil;
import org.databene.benerator.wrapper.MultiGeneratorWrapper;
import org.databene.model.function.Distribution;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlternativeGenerator<E>
extends MultiGeneratorWrapper<E, E> {
    private IntegerGenerator indexGenerator;
    private Class<E> targetType;

    public AlternativeGenerator() {
        this(Object.class, new Generator[0]);
    }

    public AlternativeGenerator(Generator<E> ... sources) {
        this(GeneratorUtil.commonTargetTypeOf(sources), new Generator[0]);
    }

    public AlternativeGenerator(Class<E> targetType, Generator<E> ... sources) {
        super(sources);
        this.targetType = targetType;
        this.indexGenerator = new IntegerGenerator(0, sources.length - 1);
    }

    public Integer getVariation1() {
        return (Integer)this.indexGenerator.getVariation1();
    }

    public void setVariation1(Integer varation1) {
        this.indexGenerator.setVariation1(varation1);
    }

    public Integer getVariation2() {
        return (Integer)this.indexGenerator.getVariation2();
    }

    public void setVariation2(Integer variation2) {
        this.indexGenerator.setVariation2(variation2);
    }

    public Distribution getDistribution() {
        return this.indexGenerator.getDistribution();
    }

    public void setDistribution(Distribution distribution) {
        this.indexGenerator.setDistribution(distribution);
    }

    @Override
    public Class<E> getGeneratedType() {
        return this.targetType;
    }

    @Override
    public void validate() {
        if (this.dirty) {
            super.validate();
            this.indexGenerator.validate();
            this.dirty = false;
        }
    }

    @Override
    public boolean available() {
        this.validate();
        for (Generator source : this.sources) {
            if (!source.available()) continue;
            return true;
        }
        return false;
    }

    @Override
    public E generate() {
        if (!this.available()) {
            GeneratorUtil.stateException(this);
        }
        for (int i = 0; i < 1000; ++i) {
            Generator generator = this.getSource((Integer)this.indexGenerator.generate());
            if (!generator.available()) continue;
            return (E)generator.generate();
        }
        throw new IllegalStateException("Unable to choose an available generator");
    }
}

