/*
 * Decompiled with CFR 0.152.
 */
package org.databene.benerator.wrapper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.databene.benerator.Generator;
import org.databene.benerator.InvalidGeneratorSetupException;
import org.databene.benerator.wrapper.CardinalGenerator;
import org.databene.commons.BeanUtil;
import org.databene.model.function.Distribution;
import org.databene.model.function.Sequence;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionGenerator<C extends Collection, I>
extends CardinalGenerator<I, C> {
    private Class<C> collectionType;

    public CollectionGenerator() {
        this(List.class, null);
    }

    public CollectionGenerator(Class<C> collectionType) {
        this(collectionType, null);
    }

    public CollectionGenerator(Class<C> collectionType, Generator<I> source) {
        this(collectionType, source, 0, 30, Sequence.RANDOM);
    }

    public CollectionGenerator(Class<C> collectionType, Generator<I> source, int minLength, int maxLength) {
        this(collectionType, source, minLength, maxLength, Sequence.RANDOM);
    }

    public CollectionGenerator(Class<C> collectionType, Generator<I> source, int minLength, int maxLength, Distribution lengthDistribution) {
        super(source, minLength, maxLength, lengthDistribution);
        this.collectionType = CollectionGenerator.mapCollectionType(collectionType);
    }

    public Class<C> getCollectionType() {
        return this.collectionType;
    }

    public void setCollectionType(Class<C> collectionType) {
        this.collectionType = collectionType;
    }

    @Override
    public void validate() {
        if (this.collectionType == null) {
            throw new InvalidGeneratorSetupException("collectionType", "undefined");
        }
        super.validate();
    }

    @Override
    public Class<C> getGeneratedType() {
        return this.collectionType;
    }

    @Override
    public C generate() {
        if (this.dirty) {
            this.validate();
        }
        Collection collection = (Collection)BeanUtil.newInstance(this.collectionType, (Object[])new Object[0]);
        int size = ((Long)this.countGenerator.generate()).intValue();
        for (int i = 0; i < size; ++i) {
            collection.add(this.source.generate());
        }
        return (C)collection;
    }

    private static <C extends Collection> Class<C> mapCollectionType(Class<C> collectionType) {
        if (List.class.equals(collectionType)) {
            return ArrayList.class;
        }
        if (Set.class.equals(collectionType)) {
            return HashSet.class;
        }
        return collectionType;
    }
}

