/*
 * Decompiled with CFR 0.152.
 */
package org.databene.benerator.wrapper;

import java.lang.reflect.Array;
import org.databene.benerator.Generator;
import org.databene.benerator.wrapper.MultiGeneratorWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeArrayGenerator<S>
extends MultiGeneratorWrapper<S, S[]> {
    private Class<S> componentType;

    public CompositeArrayGenerator() {
        super(new Generator[0]);
    }

    public CompositeArrayGenerator(Class<S> componentType, Generator<S> ... sources) {
        super(sources);
        this.componentType = componentType;
    }

    @Override
    public Class<S[]> getGeneratedType() {
        return Array.newInstance(this.componentType, 0).getClass();
    }

    @Override
    public S[] generate() {
        Object[] array = (Object[])Array.newInstance(this.componentType, this.sources.length);
        for (int i = 0; i < array.length; ++i) {
            try {
                array[i] = this.sources[i].generate();
                continue;
            }
            catch (Exception e) {
                throw new RuntimeException("Generation failed for generator #" + i + ": " + this.sources[i], e);
            }
        }
        return array;
    }
}

