/*
 * Decompiled with CFR 0.152.
 */
package org.databene.benerator.wrapper;

import org.databene.benerator.Generator;
import org.databene.benerator.IllegalGeneratorStateException;
import org.databene.benerator.InvalidGeneratorSetupException;
import org.databene.benerator.wrapper.GeneratorWrapper;
import org.databene.commons.ConversionException;
import org.databene.commons.Converter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConvertingGenerator<S, T>
extends GeneratorWrapper<S, T> {
    protected Converter<S, T> converter;

    public ConvertingGenerator() {
        this(null, null);
    }

    public ConvertingGenerator(Generator<S> source, Converter<S, T> converter) {
        super(source);
        this.converter = converter;
    }

    public Converter<S, T> getConverter() {
        return this.converter;
    }

    public void setConverter(Converter<S, T> converter) {
        this.converter = converter;
    }

    @Override
    public void validate() {
        if (this.source == null) {
            throw new InvalidGeneratorSetupException("source", "is null");
        }
        if (this.converter == null) {
            throw new InvalidGeneratorSetupException("converter", "is null");
        }
        super.validate();
    }

    @Override
    public Class<T> getGeneratedType() {
        return this.converter.getTargetType();
    }

    @Override
    public T generate() {
        try {
            Object product = this.source.generate();
            return (T)this.converter.convert(product);
        }
        catch (ConversionException e) {
            throw new IllegalGeneratorStateException(e);
        }
    }
}

