/*
 * Decompiled with CFR 0.152.
 */
package org.databene.benerator.wrapper;

import org.databene.benerator.Generator;
import org.databene.benerator.IllegalGeneratorStateException;
import org.databene.benerator.wrapper.GeneratorProxy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CyclicGeneratorProxy<E>
extends GeneratorProxy<E> {
    private boolean closed = false;

    public CyclicGeneratorProxy(Generator<E> source) {
        super(source);
    }

    @Override
    public boolean available() {
        if (this.source == null || this.closed) {
            return false;
        }
        if (!this.source.available()) {
            this.reset();
        }
        return this.source.available();
    }

    @Override
    public E generate() {
        if (this.source == null || this.closed) {
            throw new IllegalGeneratorStateException(this.getClass().getSimpleName() + " is not available");
        }
        if (!this.source.available()) {
            this.reset();
        }
        return this.source.generate();
    }

    @Override
    public void reset() {
        if (this.source != null) {
            this.source.reset();
        }
    }

    @Override
    public void close() {
        super.close();
        this.closed = true;
    }
}

