/*
 * Decompiled with CFR 0.152.
 */
package org.databene.benerator.wrapper;

import org.databene.benerator.Generator;
import org.databene.benerator.InvalidGeneratorSetupException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GeneratorWrapper<S, P>
implements Generator<P> {
    protected Generator<S> source;
    protected boolean dirty;

    public GeneratorWrapper(Generator<S> source) {
        this.source = source;
        this.dirty = true;
    }

    public Generator<S> getSource() {
        return this.source;
    }

    public void setSource(Generator<S> source) {
        this.source = source;
        this.dirty = true;
    }

    @Override
    public void validate() {
        if (this.dirty) {
            if (this.source == null) {
                throw new InvalidGeneratorSetupException("source", "is null");
            }
            this.source.validate();
            this.dirty = false;
        }
    }

    @Override
    public void reset() {
        if (this.dirty) {
            this.validate();
        }
        this.source.reset();
    }

    @Override
    public void close() {
        if (this.dirty) {
            this.validate();
        }
        this.source.close();
    }

    @Override
    public boolean available() {
        if (this.dirty) {
            this.validate();
        }
        return this.source.available();
    }

    public String toString() {
        return this.getClass().getSimpleName() + '[' + this.source + ']';
    }
}

