/*
 * Decompiled with CFR 0.152.
 */
package org.databene.benerator.wrapper;

import org.databene.benerator.Generator;
import org.databene.benerator.IllegalGeneratorStateException;
import org.databene.benerator.wrapper.CardinalGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstanceSequenceGenerator<S>
extends CardinalGenerator<S, S> {
    private long countAvailable;
    private long countUsed;
    private boolean limited = false;
    private boolean dirty = true;

    public InstanceSequenceGenerator(Generator<S> source) {
        super(source);
    }

    @Override
    public void setMaxCount(long maxCount) {
        this.limited = true;
        super.setMaxCount(maxCount);
    }

    @Override
    public Class<S> getGeneratedType() {
        return this.source.getGeneratedType();
    }

    @Override
    public void validate() {
        if (this.dirty) {
            this.countAvailable = (Long)this.countGenerator.generate();
            super.validate();
            this.dirty = false;
        }
    }

    @Override
    public boolean available() {
        this.validate();
        return super.available() && (this.countUsed < this.countAvailable || !this.limited);
    }

    @Override
    public S generate() {
        this.validate();
        if (!this.available()) {
            throw new IllegalGeneratorStateException("Generator not available.");
        }
        ++this.countUsed;
        return (S)this.source.generate();
    }

    @Override
    public void reset() {
        this.validate();
        super.reset();
        this.countAvailable = (Long)this.countGenerator.generate();
        this.countUsed = 0L;
    }

    @Override
    public void close() {
        this.validate();
        super.close();
        this.countUsed = this.countAvailable;
    }
}

