/*
 * Decompiled with CFR 0.152.
 */
package org.databene.benerator.wrapper;

import java.util.Iterator;
import org.databene.benerator.Generator;
import org.databene.benerator.IllegalGeneratorStateException;
import org.databene.benerator.InvalidGeneratorSetupException;
import org.databene.benerator.util.GeneratorUtil;
import org.databene.commons.Heavyweight;
import org.databene.commons.HeavyweightIterator;
import org.databene.commons.TypedIterable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IteratingGenerator<E>
implements Generator<E> {
    private static final int NEW = -1;
    private static final int AVAILABLE = 0;
    private static final int UTILIZED = 1;
    private static final int CLOSED = 2;
    private TypedIterable<E> iterable;
    private Iterator<E> iterator;
    private int state;

    public IteratingGenerator() {
        this(null);
    }

    public IteratingGenerator(TypedIterable<E> iterable) {
        this.iterable = iterable;
        this.state = -1;
        this.iterator = null;
    }

    public TypedIterable<E> getIterable() {
        return this.iterable;
    }

    public void setIterable(TypedIterable<E> iterable) {
        if (this.iterable != null) {
            throw new IllegalGeneratorStateException("Mutating an initialized generator");
        }
        this.iterable = iterable;
    }

    @Override
    public void validate() {
        if (this.iterable == null) {
            throw new InvalidGeneratorSetupException("iterable", "is null");
        }
    }

    @Override
    public Class<E> getGeneratedType() {
        return this.iterable.getType();
    }

    @Override
    public boolean available() {
        if (this.state == -1) {
            this.iterator = this.iterable.iterator();
            if (this.iterator.hasNext()) {
                this.state = 0;
            } else {
                this.utilized();
            }
        }
        return this.state == 0;
    }

    @Override
    public E generate() {
        try {
            if (!this.available()) {
                throw GeneratorUtil.stateException(this);
            }
            E result = this.iterator.next();
            if (!this.iterator.hasNext()) {
                this.utilized();
            }
            return result;
        }
        catch (Exception e) {
            throw new IllegalGeneratorStateException("Generation failed: ", e);
        }
    }

    @Override
    public void reset() {
        this.closeIterator();
        this.state = -1;
    }

    @Override
    public void close() {
        this.closeIterator();
        this.state = 2;
        if (this.iterable instanceof Heavyweight) {
            ((Heavyweight)this.iterable).close();
        }
    }

    private void utilized() {
        this.closeIterator();
        this.state = 1;
    }

    private void closeIterator() {
        if (this.iterator != null) {
            if (this.iterator instanceof HeavyweightIterator) {
                ((HeavyweightIterator)this.iterator).close();
            }
            this.iterator = null;
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.iterable + ']';
    }
}

