/*
 * Decompiled with CFR 0.152.
 */
package org.databene.benerator.wrapper;

import java.text.MessageFormat;
import org.databene.benerator.Generator;
import org.databene.benerator.InvalidGeneratorSetupException;
import org.databene.benerator.util.ValidatingGenerator;
import org.databene.benerator.wrapper.CompositeArrayGenerator;
import org.databene.commons.validator.StringLengthValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageGenerator
extends ValidatingGenerator<String> {
    private String pattern;
    private int minLength;
    private int maxLength;
    private CompositeArrayGenerator helper;
    private boolean dirty;

    public MessageGenerator() {
        this(null, new Generator[0]);
    }

    public MessageGenerator(String pattern, Generator ... sources) {
        this(pattern, 0, 30, sources);
    }

    public MessageGenerator(String pattern, int minLength, int maxLength, Generator ... sources) {
        super(new StringLengthValidator());
        this.pattern = pattern;
        this.minLength = minLength;
        this.maxLength = maxLength;
        this.helper = new CompositeArrayGenerator<Object>(Object.class, sources);
        this.dirty = true;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public int getMinLength() {
        return this.minLength;
    }

    public void setMinLength(int minLength) {
        this.minLength = minLength;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public void setMaxLength(int maxLength) {
        this.maxLength = maxLength;
    }

    public void setSources(Generator[] sources) {
        this.helper.setSources(sources);
    }

    @Override
    public void validate() {
        if (this.dirty) {
            if (this.pattern == null) {
                throw new InvalidGeneratorSetupException("pattern", "is null");
            }
            StringLengthValidator v = (StringLengthValidator)this.validator;
            v.setMinLength(this.minLength);
            v.setMaxLength(Integer.valueOf(this.maxLength));
            this.helper.validate();
            this.dirty = false;
        }
    }

    @Override
    public Class<String> getGeneratedType() {
        return String.class;
    }

    @Override
    public String generateImpl() {
        Object[] values = this.helper.generate();
        return MessageFormat.format(this.pattern, values);
    }

    @Override
    public void reset() {
        this.helper.reset();
    }

    @Override
    public void close() {
        this.helper.close();
    }

    @Override
    public boolean available() {
        return this.helper.available();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[pattern='" + this.pattern + "', " + this.minLength + "<=length<=" + this.maxLength + "]";
    }
}

