/*
 * Decompiled with CFR 0.152.
 */
package org.databene.benerator.wrapper;

import org.databene.benerator.Generator;
import org.databene.benerator.InvalidGeneratorSetupException;
import org.databene.commons.ArrayFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MultiGeneratorWrapper<S, P>
implements Generator<P> {
    protected Generator<S>[] sources;
    protected boolean dirty;

    public MultiGeneratorWrapper(Generator<S> ... sources) {
        this.setSources(sources);
    }

    public Generator<S>[] getSources() {
        this.validate();
        return this.sources;
    }

    public void setSources(Generator<S> ... sources) {
        this.dirty = true;
        this.sources = sources;
    }

    public Generator<S> getSource(int index) {
        this.validate();
        return this.sources[index];
    }

    @Override
    public void validate() {
        if (this.dirty) {
            if (this.sources.length == 0) {
                throw new InvalidGeneratorSetupException("sources", "is empty");
            }
            for (Generator<S> source : this.sources) {
                source.validate();
            }
            this.dirty = false;
        }
    }

    @Override
    public boolean available() {
        this.validate();
        for (Generator<S> source : this.sources) {
            if (source.available()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void reset() {
        this.validate();
        this.dirty = true;
        for (Generator<S> source : this.sources) {
            source.reset();
        }
    }

    @Override
    public void close() {
        this.validate();
        for (Generator<S> source : this.sources) {
            source.close();
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + '[' + ArrayFormat.format((Object[])this.sources) + ']';
    }
}

