/*
 * Decompiled with CFR 0.152.
 */
package org.databene.benerator.wrapper;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.databene.benerator.Generator;
import org.databene.benerator.IllegalGeneratorStateException;
import org.databene.benerator.wrapper.GeneratorProxy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NShotGeneratorProxy<E>
extends GeneratorProxy<E> {
    private static final Log logger = LogFactory.getLog(NShotGeneratorProxy.class);
    private long shots;
    private long remainingShots;

    public NShotGeneratorProxy(Generator<E> source, long shots) {
        super(source);
        this.shots = shots;
        this.remainingShots = shots;
    }

    @Override
    public boolean available() {
        if (this.remainingShots <= 0L) {
            logger.debug((Object)("requested count reached for " + this.source));
            return false;
        }
        return super.available();
    }

    @Override
    public E generate() {
        if (this.remainingShots <= 0L) {
            throw new IllegalGeneratorStateException("Generator not available.");
        }
        --this.remainingShots;
        return super.generate();
    }

    @Override
    public void reset() {
        super.reset();
        this.remainingShots = this.shots;
    }

    @Override
    public void close() {
        super.close();
        this.remainingShots = 0L;
    }
}

