/*
 * Decompiled with CFR 0.152.
 */
package org.databene.benerator.wrapper;

import org.databene.benerator.Generator;
import org.databene.benerator.IllegalGeneratorStateException;
import org.databene.benerator.util.SimpleRandom;
import org.databene.benerator.wrapper.GeneratorProxy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepeatGeneratorProxy<E>
extends GeneratorProxy<E> {
    private long minRepetitions = 0L;
    private long maxRepetitions = 3L;
    private long repCount = -1L;
    private long totalReps;
    private E next;

    public RepeatGeneratorProxy() {
        this(null, null);
    }

    public RepeatGeneratorProxy(Long minRepetitions, Long maxRepetitions) {
        this(null, minRepetitions, maxRepetitions);
    }

    public RepeatGeneratorProxy(Generator<E> source, Long minRepetitions, Long maxRepetitions) {
        super(source);
        if (minRepetitions != null) {
            this.setMinRepetitions(minRepetitions);
        }
        if (maxRepetitions != null) {
            this.setMaxRepetitions(maxRepetitions);
        }
        this.totalReps = SimpleRandom.randomLong(this.minRepetitions, this.maxRepetitions);
    }

    public long getMinRepetitions() {
        return this.minRepetitions;
    }

    public void setMinRepetitions(long minRepetitions) {
        if (minRepetitions < 0L) {
            throw new IllegalArgumentException("minRepetitions must be >= 0, was: " + minRepetitions);
        }
        this.minRepetitions = minRepetitions;
    }

    public long getMaxRepetitions() {
        return this.maxRepetitions;
    }

    public void setMaxRepetitions(long maxRepetitions) {
        if (maxRepetitions < this.minRepetitions) {
            throw new IllegalArgumentException("maxRepetitions must be >= minRepetitions");
        }
        this.maxRepetitions = maxRepetitions;
    }

    @Override
    public void validate() {
        if (this.dirty) {
            super.validate();
            this.next = this.source.generate();
        }
    }

    @Override
    public boolean available() {
        if (this.dirty) {
            this.validate();
        }
        return this.repCount < this.totalReps;
    }

    @Override
    public E generate() {
        if (this.dirty) {
            this.validate();
        }
        if (this.next == null) {
            throw new IllegalGeneratorStateException("Generator is no more available");
        }
        E result = this.next;
        ++this.repCount;
        if (this.repCount >= this.totalReps) {
            if (this.source.available()) {
                this.next = this.source.generate();
                this.totalReps = SimpleRandom.randomLong(this.minRepetitions, this.maxRepetitions);
                this.repCount = -1L;
            } else {
                this.next = null;
            }
        }
        return result;
    }
}

