/*
 * Decompiled with CFR 0.152.
 */
package org.databene.benerator.wrapper;

import org.databene.benerator.Generator;
import org.databene.benerator.IllegalGeneratorStateException;
import org.databene.benerator.InvalidGeneratorSetupException;
import org.databene.benerator.primitive.number.adapter.LongGenerator;
import org.databene.benerator.wrapper.GeneratorProxy;
import org.databene.model.function.Distribution;
import org.databene.model.function.Sequence;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SkipGeneratorProxy<E>
extends GeneratorProxy<E> {
    public static final long DEFAULT_MIN_INCREMENT = 1L;
    public static final long DEFAULT_MAX_INCREMENT = 1L;
    private LongGenerator incrementGenerator;

    public SkipGeneratorProxy() {
        this((Generator<E>)null);
    }

    public SkipGeneratorProxy(Generator<E> source) {
        this(source, 1L, 1L);
    }

    public SkipGeneratorProxy(Generator<E> source, Long minIncrement, Long maxIncrement) {
        this(source, minIncrement, maxIncrement, Sequence.RANDOM);
    }

    public SkipGeneratorProxy(Long minIncrement, Long maxIncrement) {
        this(null, minIncrement, maxIncrement);
    }

    public SkipGeneratorProxy(Generator<E> source, Long minIncrement, Long maxIncrement, Distribution incrementDistribution) {
        super(source);
        if (minIncrement == null) {
            minIncrement = 1L;
        }
        if (maxIncrement == null) {
            maxIncrement = 1L;
        }
        this.incrementGenerator = new LongGenerator(minIncrement, maxIncrement, 1L, incrementDistribution);
    }

    public long getMinIncrement() {
        return (Long)this.incrementGenerator.getMin();
    }

    public void setMinIncrement(long minIncrement) {
        this.incrementGenerator.setMin(minIncrement);
    }

    public long getMaxIncrement() {
        return (Long)this.incrementGenerator.getMax();
    }

    public void setMaxIncrement(long maxIncrement) {
        this.incrementGenerator.setMax(maxIncrement);
    }

    public Distribution getIncrementDistribution() {
        return this.incrementGenerator.getDistribution();
    }

    public void setIncrementDistribution(Distribution distribution) {
        this.incrementGenerator.setDistribution(distribution);
    }

    public Long getIncrementVariation1() {
        return (Long)this.incrementGenerator.getVariation1();
    }

    public void setIncrementVariation1(Long varation1) {
        this.incrementGenerator.setVariation1(varation1);
    }

    public Long getIncrementVariation2() {
        return (Long)this.incrementGenerator.getVariation2();
    }

    public void setIncrementVariation2(Long variation2) {
        this.incrementGenerator.setVariation2(variation2);
    }

    @Override
    public void validate() {
        if ((Long)this.incrementGenerator.getMin() < 0L) {
            throw new InvalidGeneratorSetupException("minIncrement", "less than 0");
        }
        this.incrementGenerator.validate();
        super.validate();
    }

    @Override
    public E generate() {
        if (!this.source.available()) {
            throw new IllegalGeneratorStateException("source is not available");
        }
        long increment = (Long)this.incrementGenerator.generate();
        for (long i = 0L; i < increment - 1L; ++i) {
            this.source.generate();
        }
        return this.source.generate();
    }

    @Override
    public void close() {
        super.close();
        this.incrementGenerator.close();
    }

    @Override
    public void reset() {
        super.reset();
        this.incrementGenerator.reset();
    }
}

