/*
 * Decompiled with CFR 0.152.
 */
package org.databene.benerator.wrapper;

import java.lang.reflect.Array;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.databene.benerator.Generator;
import org.databene.benerator.IllegalGeneratorStateException;
import org.databene.benerator.InvalidGeneratorSetupException;
import org.databene.benerator.wrapper.MultiGeneratorWrapper;
import org.databene.commons.ArrayFormat;
import org.databene.commons.ArrayUtil;
import org.databene.commons.NullSafeComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UniqueCompositeGenerator<S>
extends MultiGeneratorWrapper<S, S[]> {
    private static final Log logger = LogFactory.getLog(UniqueCompositeGenerator.class);
    private Class<S> componentType;
    private Object[] products;
    private boolean dirty;

    public UniqueCompositeGenerator() {
        super(new Generator[0]);
        this.dirty = true;
    }

    public UniqueCompositeGenerator(Class<S> componentType, Generator<S> ... sources) {
        super(sources);
        this.componentType = componentType;
        this.dirty = true;
    }

    @Override
    public Class<S[]> getGeneratedType() {
        return Array.newInstance(this.componentType, 0).getClass();
    }

    @Override
    public void validate() {
        if (this.dirty) {
            super.validate();
            if (this.sources.length == 0) {
                throw new InvalidGeneratorSetupException("source", "is null");
            }
            this.products = new Object[this.sources.length];
            for (int i = 0; i < this.products.length; ++i) {
                if (!this.sources[i].available()) {
                    throw new InvalidGeneratorSetupException("Sub generator not available: " + this.sources[i]);
                }
                this.products[i] = this.sources[i].generate();
            }
            this.dirty = false;
        }
    }

    @Override
    public boolean available() {
        if (this.dirty) {
            this.validate();
        }
        return this.products != null;
    }

    @Override
    public S[] generate() {
        if (!this.available()) {
            throw new IllegalGeneratorStateException("Generator is not available");
        }
        Object[] result = ArrayUtil.copyOfRange((Object[])this.products, (int)0, (int)this.products.length);
        this.fetchNext(0);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("generated: " + ArrayFormat.format((Object[])result)));
        }
        return result;
    }

    @Override
    public void reset() {
        super.reset();
        this.dirty = true;
    }

    private void fetchNext(int index) {
        if (index >= this.sources.length) {
            this.products = null;
            return;
        }
        boolean rep = false;
        Generator gen = this.sources[index];
        if (gen.available()) {
            Object tmp = gen.generate();
            if (!NullSafeComparator.equals((Object)this.products[index], tmp)) {
                this.products[index] = tmp;
                return;
            }
            rep = true;
        }
        this.fetchNext(index + 1);
        if (this.products != null && !rep) {
            gen.reset();
            this.products[index] = gen.generate();
        }
    }
}

