/*
 * Decompiled with CFR 0.152.
 */
package org.databene.dataset;

import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Dataset {
    private String id;
    private String type;
    private String name;
    private Set<Dataset> subSets;

    Dataset(String type, String name) {
        if (type == null) {
            throw new IllegalArgumentException("type is null");
        }
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        this.id = type + ':' + name;
        this.type = type;
        this.name = name;
        this.subSets = new HashSet<Dataset>();
    }

    public String getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public void addSubSet(Dataset subSet) {
        this.subSets.add(subSet);
    }

    public Set<Dataset> getSubSets() {
        return this.subSets;
    }

    public Set<Dataset> getAtomicSubSets() {
        HashSet<Dataset> atomicSubSets = new HashSet<Dataset>();
        for (Dataset set : this.subSets) {
            if (set.getSubSets().size() == 0) {
                atomicSubSets.add(set);
                continue;
            }
            atomicSubSets.addAll(set.getAtomicSubSets());
        }
        return atomicSubSets;
    }

    public String toString() {
        return this.name;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Dataset that = (Dataset)obj;
        return this.id.equals(that.id);
    }
}

