/*
 * Decompiled with CFR 0.152.
 */
package org.databene.dataset;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.databene.commons.ArrayBuilder;
import org.databene.commons.ConfigurationError;
import org.databene.commons.IOUtil;
import org.databene.commons.StringUtil;
import org.databene.dataset.Dataset;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatasetFactory {
    protected static Map<String, Map<String, Dataset>> types = new HashMap<String, Map<String, Dataset>>();

    public static Dataset getDataset(String type, String name) {
        Map<String, Dataset> sets = types.get(type);
        if (sets == null) {
            sets = DatasetFactory.parseDatasetTypeConfig(type);
        }
        return DatasetFactory.getDataset(type, name, sets);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String[] getDataFiles(String filenamePattern, String datasetName, String nesting) {
        Dataset dataset = DatasetFactory.getDataset(nesting, datasetName);
        ArrayBuilder builder = new ArrayBuilder(String.class);
        if (dataset.getAtomicSubSets().size() == 0) {
            String filename = MessageFormat.format(filenamePattern, datasetName);
            if (!IOUtil.isURIAvailable((String)filename)) throw new ConfigurationError("File not found: " + filename);
            builder.append((Object)filename);
            return (String[])builder.toArray();
        } else {
            for (Dataset atomicSet : dataset.getAtomicSubSets()) {
                String filename = MessageFormat.format(filenamePattern, atomicSet);
                if (!IOUtil.isURIAvailable((String)filename)) continue;
                builder.append((Object)filename);
            }
        }
        return (String[])builder.toArray();
    }

    private static Dataset getDataset(String type, String name, Map<String, Dataset> sets) {
        Dataset dataset = sets.get(name);
        if (dataset == null) {
            dataset = new Dataset(type, name);
            sets.put(name, dataset);
        }
        return dataset;
    }

    private static synchronized Map<String, Dataset> parseDatasetTypeConfig(String nesting) {
        try {
            HashMap<String, Dataset> sets = new HashMap<String, Dataset>();
            Map properties = IOUtil.readProperties((String)(nesting + ".set.properties"));
            for (Map.Entry entry : properties.entrySet()) {
                String[] subSetNames;
                String name = (String)entry.getKey();
                Dataset dataset = DatasetFactory.getDataset(nesting, name, sets);
                for (String subSetName : subSetNames = StringUtil.tokenize((String)((String)entry.getValue()), (char)',')) {
                    dataset.addSubSet(DatasetFactory.getDataset(nesting, subSetName, sets));
                }
            }
            types.put(nesting, sets);
            return sets;
        }
        catch (IOException e) {
            throw new ConfigurationError("Setup for Dataset type failed: " + nesting, (Throwable)e);
        }
    }
}

