/*
 * Decompiled with CFR 0.152.
 */
package org.databene.domain.address;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.databene.commons.ConfigurationError;
import org.databene.commons.Context;
import org.databene.commons.Converter;
import org.databene.commons.IOUtil;
import org.databene.commons.context.DefaultContext;
import org.databene.commons.converter.FixedSourceTypeConverter;
import org.databene.domain.address.Address;
import org.databene.script.Script;
import org.databene.script.ScriptException;
import org.databene.script.freemarker.FreeMarkerScriptFactory;

public class AddressFormat {
    private static final String CONFIG_FILE = "org/databene/domain/address/addressFormat.properties";
    private static final Map<String, AddressFormat> instances = new HashMap<String, AddressFormat>();
    private static final FreeMarkerScriptFactory SCRIPT_FACTORY = new FreeMarkerScriptFactory();
    public static AddressFormat US = AddressFormat.getInstance("US");
    public static AddressFormat AU = AddressFormat.getInstance("AU");
    public static AddressFormat DE = AddressFormat.getInstance("DE");
    private String pattern;
    private Script script;

    public AddressFormat(String pattern) {
        this.pattern = pattern;
        this.script = SCRIPT_FACTORY.parseText(pattern);
    }

    public static AddressFormat getInstance(String country) {
        if (instances.size() == 0) {
            try {
                IOUtil.readProperties((String)CONFIG_FILE, (Converter)new FixedSourceTypeConverter<Map.Entry, Map.Entry>(Map.Entry.class, Map.Entry.class){

                    public Map.Entry convert(Map.Entry entry) {
                        String pt = (String)entry.getValue();
                        instances.put((String)entry.getKey(), new AddressFormat(pt));
                        return entry;
                    }
                });
            }
            catch (IOException e) {
                throw new ConfigurationError("Error while processing AddressFormat configuration", (Throwable)e);
            }
        }
        return instances.get(country);
    }

    public String getPattern() {
        return this.pattern;
    }

    public String format(Address address) {
        try {
            DefaultContext context = new DefaultContext();
            context.set("address", (Object)address);
            StringWriter out = new StringWriter();
            this.script.execute((Context)context, (Writer)out);
            return out.toString();
        }
        catch (IOException e) {
            throw new ScriptException("Error during script processing", (Throwable)e);
        }
    }
}

