/*
 * Decompiled with CFR 0.152.
 */
package org.databene.domain.address;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.databene.benerator.IllegalGeneratorStateException;
import org.databene.benerator.primitive.regex.RegexStringGenerator;
import org.databene.benerator.util.LightweightGenerator;
import org.databene.domain.address.Address;
import org.databene.domain.address.City;
import org.databene.domain.address.CityGenerator;
import org.databene.domain.address.Country;
import org.databene.domain.address.MobilePhoneNumberGenerator;
import org.databene.domain.address.PhoneNumber;
import org.databene.domain.address.Street;
import org.databene.domain.address.StreetNameGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddressGenerator
extends LightweightGenerator<Address> {
    private static Log logger = LogFactory.getLog(AddressGenerator.class);
    private Country country;
    private CityGenerator cityGenerator;
    private MobilePhoneNumberGenerator mobilePhoneNumberGenerator;
    private StreetNameGenerator streetNameGenerator;
    private RegexStringGenerator localPhoneNumberGenerator;

    public AddressGenerator() {
        this(Country.getDefault());
    }

    public AddressGenerator(Country country) {
        super(Address.class);
        this.init(country);
    }

    private void init(Country country) {
        try {
            this.country = country;
            this.cityGenerator = new CityGenerator(country);
            this.streetNameGenerator = new StreetNameGenerator(country.getIsoCode());
            this.mobilePhoneNumberGenerator = new MobilePhoneNumberGenerator(country);
            this.localPhoneNumberGenerator = new RegexStringGenerator("[1-9]\\d{5}");
        }
        catch (RuntimeException e) {
            Country fallBackCountry = Country.getFallback();
            if (!fallBackCountry.equals(country)) {
                logger.error((Object)("Cannot generate addresses for " + country + ", falling back to " + fallBackCountry));
                this.init(fallBackCountry);
            }
            throw e;
        }
    }

    public void setDataset(String dataset) {
        this.init(Country.getInstance(dataset));
    }

    @Override
    public Address generate() throws IllegalGeneratorStateException {
        City city = (City)this.cityGenerator.generate();
        Street street = new Street(city, (String)this.streetNameGenerator.generate());
        String[] data = street.generateHouseNumberWithZipCode();
        String houseNumber = data[0];
        String zipCode = data[1];
        PhoneNumber privatePhone = this.generatePhoneNumber(city);
        PhoneNumber officePhone = this.generatePhoneNumber(city);
        PhoneNumber mobilePhone = this.mobilePhoneNumberGenerator.generate();
        PhoneNumber fax = this.generatePhoneNumber(city);
        return new Address(street.getName(), houseNumber, zipCode, city.getName(), city.getState().getId(), this.country, privatePhone, officePhone, mobilePhone, fax);
    }

    public String toString() {
        return this.getClass().getSimpleName() + '[' + this.country + ']';
    }

    private PhoneNumber generatePhoneNumber(City city) {
        int localPhoneNumberLength = 10 - city.getAreaCode().length();
        this.localPhoneNumberGenerator.setPattern("[2-9]\\d{" + (localPhoneNumberLength - 1) + '}');
        String localCode = this.localPhoneNumberGenerator.generate();
        return new PhoneNumber(this.country.getPhoneCode(), city.getAreaCode(), localCode);
    }
}

