/*
 * Decompiled with CFR 0.152.
 */
package org.databene.domain.address;

import java.util.Collection;
import java.util.Locale;
import java.util.SortedSet;
import java.util.TreeSet;
import org.databene.commons.Escalator;
import org.databene.commons.LoggerEscalator;
import org.databene.commons.NullSafeComparator;
import org.databene.commons.StringUtil;
import org.databene.domain.address.State;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class City {
    private static final Escalator escalator = new LoggerEscalator();
    private String name;
    private String nameExtension;
    private SortedSet<String> zipCodes;
    private String areaCode;
    private State state;
    private Locale language;
    private int population;

    public City(State state, String name, String addition, Collection<String> zipCodes, String areaCode) {
        if (areaCode == null) {
            throw new IllegalArgumentException("Area Code is null for " + name);
        }
        this.state = state;
        this.name = name;
        this.nameExtension = addition;
        this.zipCodes = new TreeSet<String>(zipCodes);
        this.areaCode = areaCode;
    }

    public String getNameExtension() {
        return this.nameExtension;
    }

    public void setNameExtension(String nameExtension) {
        this.nameExtension = nameExtension;
    }

    public Collection<String> getZipCodes() {
        return this.zipCodes;
    }

    public void setZipCodes(Collection<String> zipCodes) {
        this.zipCodes.clear();
        this.zipCodes.addAll(zipCodes);
    }

    public void addZipCode(String zipCode) {
        this.zipCodes.add(zipCode);
    }

    public String getAreaCode() {
        return this.areaCode;
    }

    public void setAreaCode(String phoneCode) {
        this.areaCode = phoneCode;
    }

    @Deprecated
    public String getPhoneCode() {
        escalator.escalate("The 'phoneCode' property is deprecated, please use 'areaCode' instead", City.class, (Object)"Called setPhoneCode()");
        return this.getAreaCode();
    }

    @Deprecated
    public void setPhoneCode(String areaCode) {
        escalator.escalate("The 'phoneCode' property is deprecated, please use 'areaCode' instead", City.class, (Object)"Called getPhoneCode()");
        this.setAreaCode(areaCode);
    }

    public State getState() {
        return this.state;
    }

    public void setState(State state) {
        this.state = state;
    }

    public String getName() {
        return this.name;
    }

    public Locale getLanguage() {
        return this.language;
    }

    public void setLanguage(Locale language) {
        this.language = language;
    }

    public int getPopulation() {
        return this.population;
    }

    public void setPopulation(int population) {
        this.population = population;
    }

    public String toString() {
        return this.name + (StringUtil.isEmpty((String)this.nameExtension) ? "" : (Character.isLetter(this.nameExtension.charAt(0)) ? " " : "") + this.nameExtension);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        City that = (City)o;
        if (!this.name.equals(that.name)) {
            return false;
        }
        if (!NullSafeComparator.equals((Object)this.nameExtension, (Object)that.nameExtension)) {
            return false;
        }
        return NullSafeComparator.equals((Object)this.state, (Object)that.state);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 29 * result + NullSafeComparator.hashCode((Object)this.nameExtension);
        result = 29 * result + NullSafeComparator.hashCode((Object)this.state);
        return result;
    }
}

