/*
 * Decompiled with CFR 0.152.
 */
package org.databene.domain.address;

import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.databene.commons.ArrayFormat;
import org.databene.commons.ArrayUtil;
import org.databene.commons.Assert;
import org.databene.commons.CollectionUtil;
import org.databene.commons.LocaleUtil;
import org.databene.commons.ParseUtil;
import org.databene.commons.StringUtil;
import org.databene.commons.iterator.ConvertingIterator;
import org.databene.document.csv.BeanCSVWriter;
import org.databene.document.csv.CSVLineIterator;
import org.databene.domain.address.City;
import org.databene.domain.address.CityId;
import org.databene.domain.address.Country;
import org.databene.domain.address.State;
import org.databene.platform.bean.Entity2BeanConverter;
import org.databene.platform.csv.CSVEntityIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CityManager {
    private static final Log logger = LogFactory.getLog(CityManager.class);
    private static Set<String> simpleLocatorWords = CollectionUtil.toSet((Object[])new String[]{"b.", "bei", "im", "am", "ob", "zum", "sopra", "di", "in"});
    private static Set<String[]> complexLocatorWords = CollectionUtil.toSet((Object[])new String[][]{{"in", "der"}, {"an", "der"}, {"ob", "der"}});
    private static Set<String> prefixes = CollectionUtil.toSet((Object[])new String[]{"St.", "S.", "Alt", "Bad", "Markt", "Hofamt", "Maria", "Deutsch", "Moorbad", "Bairisch", "Klein", "Hohe", "Gro\ufffd", "La", "Le", "Les", "San", "Santa", "Val", "Monte", "Ponte", "Castel", "Riva", "Villa", "Santa Maria"});
    private static Set<String> suffixes = CollectionUtil.toSet((Object[])new String[]{"Stadt", "Land", "Umgebung", "Kurort", "Markt", "Neustadt", "Neudorf", "II", "Inferiore", "Superiore"});
    private static Set<String> suspectiveNames = new HashSet<String>();

    public static void readCities(Country country, String filename) throws IOException {
        CityManager.readCities(country, filename, new HashMap<String, String>());
    }

    public static void readCities(Country country, String filename, Map<String, String> defaults) throws IOException {
        CityManager.parseStateFile(country);
        int warnCount = CityManager.parseCityFile(country, filename, defaults);
        if (warnCount > 0) {
            logger.warn((Object)(warnCount + " warnings"));
        }
    }

    private static void parseStateFile(Country country) {
        try {
            ConvertingIterator iterator = new ConvertingIterator((Iterator)((Object)new CSVEntityIterator("org/databene/domain/address/state_" + country.getIsoCode() + ".csv", "State", ',', "UTF-8")), new Entity2BeanConverter<State>(State.class));
            while (iterator.hasNext()) {
                State state = (State)iterator.next();
                country.addState(state);
            }
        }
        catch (FileNotFoundException e) {
            logger.warn((Object)"No state definition file found:");
        }
    }

    private static int parseCityFile(Country country, String filename, Map<String, String> defaults) throws IOException {
        CSVLineIterator iterator = new CSVLineIterator(filename, ';', "UTF-8");
        String[] header = iterator.next();
        int warnCount = 0;
        while (iterator.hasNext()) {
            CityId cityId;
            String cityIdString;
            String stateId;
            State state;
            Object[] cells = iterator.next();
            if (cells.length == 0) continue;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)ArrayFormat.format((String)";", (Object[])cells));
            }
            if (cells.length == 1) continue;
            HashMap<String, String> instance = new HashMap<String, String>();
            for (int i = 0; i < cells.length; ++i) {
                instance.put(header[i], (String)cells[i]);
            }
            if (logger.isDebugEnabled()) {
                logger.debug(instance);
            }
            if ((state = country.getState(stateId = (String)instance.get("state"))) == null) {
                state = new State(stateId);
                String stateName = (String)instance.get("state.name");
                if (stateName != null) {
                    stateName = StringUtil.normalizeName((String)stateName);
                    state.setName(stateName);
                }
                country.addState(state);
            }
            if (StringUtil.isEmpty((String)(cityIdString = (String)instance.get("municipality")))) {
                cityIdString = (String)instance.get("city");
            }
            if (!StringUtil.isEmpty((String)cityIdString)) {
                cityId = CityManager.parseCityName(cityIdString, stateId, true);
            } else {
                String cityName = (String)instance.get("name");
                String cityNameExtension = (String)instance.get("nameExtension");
                cityId = new CityId(cityName, cityNameExtension);
            }
            CityHelper city = (CityHelper)state.getCity(cityId);
            String zipCode = (String)instance.get("zipCode");
            String lang = CityManager.getValue(instance, "language", defaults);
            if (city == null) {
                String areaCode = CityManager.getValue(instance, "areaCode", defaults);
                if (StringUtil.isEmpty((String)areaCode)) {
                    ++warnCount;
                    logger.warn((Object)("areaCode is not provided for city: '" + cityId));
                }
                city = new CityHelper(state, cityId, CollectionUtil.toList((Object[])new String[]{zipCode}), areaCode);
                if (!StringUtil.isEmpty((String)lang)) {
                    city.setLanguage(LocaleUtil.getLocale((String)lang));
                }
                state.addCity(cityId, city);
                city.setState(state);
                continue;
            }
            city.addZipCode(zipCode);
        }
        return warnCount;
    }

    public static void persistCities(Country country, String filename) throws IOException {
        BeanCSVWriter writer = new BeanCSVWriter((Writer)new FileWriter(filename), ';', new String[]{"state.country.isoCode", "state.id", "name", "nameExtension", "zipCode", "areaCode", "language"});
        for (State state : country.getStates()) {
            for (City city : state.getCities()) {
                for (String zipCode : city.getZipCodes()) {
                    ((CityHelper)city).setZipCode(zipCode);
                    writer.writeElement((Object)city);
                }
            }
        }
        writer.close();
    }

    private static String getValue(Map<String, String> instance, String key, Map<String, String> defaults) {
        String value = instance.get(key);
        if (value == null) {
            value = defaults.get(key);
        }
        return value;
    }

    static CityId parseCityName(String cityName, String stateId, boolean quiet) {
        Assert.notNull((Object)StringUtil.isEmpty((String)cityName), (String)"name");
        Object[] nameParts = StringUtil.tokenize((String)cityName, (char)' ');
        String name = "";
        Object extension = "";
        while (nameParts.length > 1 && prefixes.contains(nameParts[0])) {
            name = CityManager.append(name, nameParts[0]);
            nameParts = (String[])ArrayUtil.remove((Object[])nameParts, (int)0);
        }
        for (int i = 0; i < nameParts.length; ++i) {
            if (!ParseUtil.isPositiveNumber((String)nameParts[i])) continue;
            if (i < nameParts.length - 1) {
                nameParts = (String[])ArrayUtil.copyOfRange((Object[])nameParts, (int)0, (int)i);
                break;
            }
            nameParts = (String[])ArrayUtil.remove((Object[])nameParts, (int)(nameParts.length - 1));
            break;
        }
        if (nameParts.length > 1 && ((String)nameParts[nameParts.length - 1]).equals(stateId)) {
            extension = nameParts[nameParts.length - 1];
            nameParts = (String[])ArrayUtil.remove((Object[])nameParts, (int)(nameParts.length - 1));
        } else {
            int bracketStart = -1;
            for (int i = 1; i < nameParts.length; ++i) {
                if (((String)nameParts[i]).charAt(0) != '(') continue;
                bracketStart = i;
                break;
            }
            if (bracketStart > 0 && ((String)nameParts[nameParts.length - 1]).endsWith(")")) {
                extension = ArrayFormat.format((String)" ", (Object[])ArrayUtil.copyOfRange((Object[])nameParts, (int)bracketStart, (int)(nameParts.length - bracketStart)));
                nameParts = (String[])ArrayUtil.copyOfRange((Object[])nameParts, (int)0, (int)bracketStart);
            } else if (nameParts.length >= 4) {
                for (String[] locator : complexLocatorWords) {
                    int locatorStartIndex = -1;
                    boolean match = false;
                    for (int startIndex = 1; !match && startIndex < nameParts.length - 2; ++startIndex) {
                        if (nameParts.length - startIndex > locator.length) {
                            match = true;
                            for (int i = 0; i < locator.length; ++i) {
                                if (((String)nameParts[startIndex + i]).equals(locator[i])) continue;
                                match = false;
                            }
                        }
                        if (!match) continue;
                        locatorStartIndex = startIndex;
                    }
                    if (!match) continue;
                    Object[] locatorParts = (String[])ArrayUtil.copyOfRange((Object[])nameParts, (int)locatorStartIndex, (int)(nameParts.length - locatorStartIndex));
                    extension = ArrayFormat.format((String)" ", (Object[])locatorParts);
                    nameParts = (String[])ArrayUtil.copyOfRange((Object[])nameParts, (int)0, (int)locatorStartIndex);
                    break;
                }
            }
            if (nameParts.length >= 3) {
                for (int startIndex = 1; startIndex < nameParts.length - 1; ++startIndex) {
                    if (!simpleLocatorWords.contains(nameParts[startIndex])) continue;
                    String locationString = ArrayFormat.format((String)" ", (Object[])ArrayUtil.copyOfRange((Object[])nameParts, (int)startIndex, (int)(nameParts.length - startIndex)));
                    extension = CityManager.append(locationString, (String)extension);
                    nameParts = (String[])ArrayUtil.copyOfRange((Object[])nameParts, (int)0, (int)startIndex);
                    break;
                }
            }
        }
        if (nameParts.length > 1 && suffixes.contains(nameParts[nameParts.length - 1])) {
            extension = CityManager.append((String)extension, (String)nameParts[nameParts.length - 1]);
            nameParts = (String[])ArrayUtil.remove((Object[])nameParts, (int)(nameParts.length - 1));
        }
        name = CityManager.append(name, ArrayFormat.format((String)" ", (Object[])nameParts));
        if (nameParts.length != 1) {
            suspectiveNames.add(name);
            if (!quiet) {
                logger.info((Object)("Double name or possible parsing error: " + name));
            }
        }
        name = StringUtil.normalizeName((String)name);
        CityId cityId = new CityId(name, (String)extension);
        return cityId;
    }

    private static String append(String name, String namePart) {
        return CityManager.append(name, namePart, " ");
    }

    private static String append(String name, String namePart, String separator) {
        if (StringUtil.isEmpty((String)name)) {
            if (StringUtil.isEmpty((String)namePart)) {
                return "";
            }
            return namePart;
        }
        if (StringUtil.isEmpty((String)namePart)) {
            return name;
        }
        return name + separator + namePart;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CityHelper
    extends City {
        private String zipCode;

        public CityHelper(State state, CityId cityId, List<String> zipCodes, String areaCode) {
            super(state, cityId.getName(), cityId.getNameExtension(), zipCodes, areaCode);
        }

        public String getZipCode() {
            return this.zipCode;
        }

        public void setZipCode(String zipCode) {
            this.zipCode = zipCode;
        }
    }
}

