/*
 * Decompiled with CFR 0.152.
 */
package org.databene.domain.address;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.databene.commons.ConfigurationError;
import org.databene.commons.LocaleUtil;
import org.databene.commons.StringUtil;
import org.databene.commons.collection.OrderedNameMap;
import org.databene.document.csv.CSVLineIterator;
import org.databene.domain.address.State;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Country {
    private static final String DEFAULT_MOBILE_PHONE_PATTERN = "[1-9][0-9][0-9]";
    private static final Log logger = LogFactory.getLog(Country.class);
    private static String FILE_NAME = "org/databene/domain/address/country.csv";
    private static Map<String, Country> instances = new HashMap<String, Country>(250);
    public static final Country GERMANY;
    public static final Country AUSTRIA;
    public static final Country SWITZERLAND;
    public static final Country LIECHTENSTEIN;
    public static final Country BELGIUM;
    public static final Country NETHERLANDS;
    public static final Country LUXEMBURG;
    public static final Country DENMARK;
    public static final Country FINLAND;
    public static final Country IRELAND;
    public static final Country ICELAND;
    public static final Country NORWAY;
    public static final Country SWEDEN;
    public static final Country UNITED_KINGDOM;
    public static final Country GREAT_BRITAIN;
    public static final Country ITALY;
    public static final Country SAN_MARINO;
    public static final Country MALTA;
    public static final Country FRANCE;
    public static final Country MONACO;
    public static final Country ANDORRA;
    public static final Country SPAIN;
    public static final Country PORTUGAL;
    public static final Country GREECE;
    public static final Country CYPRUS;
    public static final Country TURKEY;
    public static final Country ALBANIA;
    public static final Country BOSNIA_AND_HERZEGOVINA;
    public static final Country BULGARIA;
    public static final Country BELARUS;
    public static final Country CZECH_REPUBLIC;
    public static final Country ESTONIA;
    public static final Country CROATIA;
    public static final Country HUNGARY;
    public static final Country LITHUANIA;
    public static final Country LATVIA;
    public static final Country POLAND;
    public static final Country ROMANIA;
    public static final Country RUSSIA;
    public static final Country SLOVENIA;
    public static final Country SLOVAKIA;
    public static final Country UKRAINE;
    public static final Country UNITED_ARAB_EMIRATES;
    public static final Country AFGHANISTAN;
    public static final Country BAHRAIN;
    public static final Country ISRAEL;
    public static final Country IRAN;
    public static final Country IRAQ;
    public static final Country JORDAN;
    public static final Country KAZAKHSTAN;
    public static final Country PAKISTAN;
    public static final Country QATAR;
    public static final Country SAUDI_ARABIA;
    public static final Country ALGERIA;
    public static final Country EGYPT;
    public static final Country GHANA;
    public static final Country KENYA;
    public static final Country SOUTH_AFRICA;
    public static final Country USA;
    public static final Country US;
    public static final Country CANADA;
    public static final Country BAHAMAS;
    public static final Country MEXICO;
    public static final Country ARGENTINA;
    public static final Country BRAZIL;
    public static final Country CHILE;
    public static final Country ECUADOR;
    public static final Country CHINA;
    public static final Country INDONESIA;
    public static final Country INDIA;
    public static final Country JAPAN;
    public static final Country KOREA_PR;
    public static final Country KOREA_R;
    public static final Country MALAYSIA;
    public static final Country SINGAPORE;
    public static final Country THAILAND;
    public static final Country TAIWAN;
    public static final Country VIETNAM;
    public static final Country NEW_ZEALAND;
    public static final Country AUSTRALIA;
    private static Country defaultCountry;
    private String isoCode;
    private String phoneCode;
    private String mobileCodePattern;
    private Locale countryLocale;
    private Locale defaultLanguage;
    private Map<String, State> states;

    private static void parseConfigFile() {
        CSVLineIterator iterator = null;
        try {
            iterator = new CSVLineIterator(FILE_NAME, ',', true);
            logger.debug((Object)("Parsing country setup file " + FILE_NAME));
            while (iterator.hasNext()) {
                String[] cells = iterator.next();
                String isoCode = cells[0];
                String defaultLocale = cells.length > 1 && !StringUtil.isEmpty((String)cells[1]) ? cells[1] : "en";
                String phoneCode = cells.length > 2 ? cells[2] : null;
                String mobilCodePattern = cells.length > 3 ? cells[3] : DEFAULT_MOBILE_PHONE_PATTERN;
                Country country = new Country(isoCode, defaultLocale, phoneCode, mobilCodePattern);
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("parsed " + country));
            }
        }
        catch (IOException e) {
            throw new ConfigurationError("Country definition file could not be processed. ", (Throwable)e);
        }
        finally {
            if (iterator != null) {
                iterator.close();
            }
        }
    }

    private Country(String isoCode, String defaultLanguage, String phoneCode, String mobilCodePattern) {
        this.isoCode = isoCode;
        this.defaultLanguage = LocaleUtil.getLocale((String)defaultLanguage);
        this.phoneCode = phoneCode;
        this.countryLocale = new Locale(LocaleUtil.getLocale((String)defaultLanguage).getLanguage(), isoCode);
        this.mobileCodePattern = mobilCodePattern;
        this.states = new OrderedNameMap();
        instances.put(isoCode, this);
    }

    public String getIsoCode() {
        return this.isoCode;
    }

    public String getName() {
        return this.countryLocale.getDisplayCountry(Locale.getDefault());
    }

    public String getLocalName() {
        return this.countryLocale.getDisplayCountry(new Locale(this.defaultLanguage.getLanguage()));
    }

    public Locale getDefaultLanguage() {
        return this.defaultLanguage;
    }

    public String getPhoneCode() {
        return this.phoneCode;
    }

    public String getMobileCodePattern() {
        return this.mobileCodePattern;
    }

    public State getState(String stateId) {
        return this.states.get(stateId);
    }

    public Collection<State> getStates() {
        return this.states.values();
    }

    public void addState(State state) {
        state.setCountry(this);
        this.states.put(state.getId(), state);
    }

    public static Collection<Country> getInstances() {
        return instances.values();
    }

    public static Country getInstance(String isoCode) {
        Country country = instances.get(isoCode.toUpperCase());
        if (country == null) {
            country = new Country(isoCode, Locale.getDefault().getLanguage(), "[2-9][0-9][0-9]", DEFAULT_MOBILE_PHONE_PATTERN);
        }
        return country;
    }

    public static Country getDefault() {
        return defaultCountry;
    }

    public static void setDefault(Country country) {
        defaultCountry = country;
    }

    public static Country getFallback() {
        return US;
    }

    public String toString() {
        return this.getName();
    }

    public int hashCode() {
        return this.isoCode.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Country other = (Country)obj;
        return this.isoCode.equals(other.isoCode);
    }

    static {
        Country.parseConfigFile();
        GERMANY = Country.getInstance("DE");
        AUSTRIA = Country.getInstance("AT");
        SWITZERLAND = Country.getInstance("CH");
        LIECHTENSTEIN = Country.getInstance("LI");
        BELGIUM = Country.getInstance("BE");
        NETHERLANDS = Country.getInstance("NL");
        LUXEMBURG = Country.getInstance("LU");
        DENMARK = Country.getInstance("DK");
        FINLAND = Country.getInstance("FI");
        IRELAND = Country.getInstance("IE");
        ICELAND = Country.getInstance("IS");
        NORWAY = Country.getInstance("NO");
        SWEDEN = Country.getInstance("SE");
        UNITED_KINGDOM = Country.getInstance("GB");
        GREAT_BRITAIN = Country.getInstance("GB");
        ITALY = Country.getInstance("IT");
        SAN_MARINO = Country.getInstance("SM");
        MALTA = Country.getInstance("MT");
        FRANCE = Country.getInstance("FR");
        MONACO = Country.getInstance("MC");
        ANDORRA = Country.getInstance("AD");
        SPAIN = Country.getInstance("ES");
        PORTUGAL = Country.getInstance("PT");
        GREECE = Country.getInstance("GR");
        CYPRUS = Country.getInstance("CY");
        TURKEY = Country.getInstance("TR");
        ALBANIA = Country.getInstance("AL");
        BOSNIA_AND_HERZEGOVINA = Country.getInstance("BA");
        BULGARIA = Country.getInstance("BG");
        BELARUS = Country.getInstance("BY");
        CZECH_REPUBLIC = Country.getInstance("CZ");
        ESTONIA = Country.getInstance("EE");
        CROATIA = Country.getInstance("HR");
        HUNGARY = Country.getInstance("HU");
        LITHUANIA = Country.getInstance("LT");
        LATVIA = Country.getInstance("LV");
        POLAND = Country.getInstance("PL");
        ROMANIA = Country.getInstance("RO");
        RUSSIA = Country.getInstance("RU");
        SLOVENIA = Country.getInstance("SI");
        SLOVAKIA = Country.getInstance("SK");
        UKRAINE = Country.getInstance("UA");
        UNITED_ARAB_EMIRATES = Country.getInstance("AE");
        AFGHANISTAN = Country.getInstance("AF");
        BAHRAIN = Country.getInstance("BH");
        ISRAEL = Country.getInstance("IL");
        IRAN = Country.getInstance("IR");
        IRAQ = Country.getInstance("IQ");
        JORDAN = Country.getInstance("JO");
        KAZAKHSTAN = Country.getInstance("KZ");
        PAKISTAN = Country.getInstance("PK");
        QATAR = Country.getInstance("QA");
        SAUDI_ARABIA = Country.getInstance("SA");
        ALGERIA = Country.getInstance("AL");
        EGYPT = Country.getInstance("EG");
        GHANA = Country.getInstance("GH");
        KENYA = Country.getInstance("KE");
        SOUTH_AFRICA = Country.getInstance("ZA");
        US = USA = Country.getInstance("US");
        CANADA = Country.getInstance("CA");
        BAHAMAS = Country.getInstance("BS");
        MEXICO = Country.getInstance("MX");
        ARGENTINA = Country.getInstance("AR");
        BRAZIL = Country.getInstance("BR");
        CHILE = Country.getInstance("CL");
        ECUADOR = Country.getInstance("EC");
        CHINA = Country.getInstance("CN");
        INDONESIA = Country.getInstance("ID");
        INDIA = Country.getInstance("IN");
        JAPAN = Country.getInstance("JP");
        KOREA_PR = Country.getInstance("KP");
        KOREA_R = Country.getInstance("KR");
        MALAYSIA = Country.getInstance("MY");
        SINGAPORE = Country.getInstance("SG");
        THAILAND = Country.getInstance("TH");
        TAIWAN = Country.getInstance("TW");
        VIETNAM = Country.getInstance("VN");
        NEW_ZEALAND = Country.getInstance("NZ");
        AUSTRALIA = Country.getInstance("AU");
        defaultCountry = Country.getInstance(LocaleUtil.getDefaultCountryCode());
    }
}

