/*
 * Decompiled with CFR 0.152.
 */
package org.databene.domain.address;

import org.databene.benerator.Generator;
import org.databene.benerator.primitive.regex.RegexStringGenerator;
import org.databene.benerator.util.LightweightGenerator;
import org.databene.domain.address.Country;
import org.databene.domain.address.PhoneNumber;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MobilePhoneNumberGenerator
extends LightweightGenerator<PhoneNumber> {
    private Country country;
    private Generator<String> mobilePreCodeGenerator;
    private Generator<String> mobileLocalCodeGenerator;

    public MobilePhoneNumberGenerator(Country country) {
        super(PhoneNumber.class);
        this.country = country;
        this.mobilePreCodeGenerator = new RegexStringGenerator(country.getMobileCodePattern());
        this.mobileLocalCodeGenerator = new RegexStringGenerator("[1-9]\\d{6,7}");
    }

    @Override
    public PhoneNumber generate() {
        String preCode = this.mobilePreCodeGenerator.generate();
        String localCode = this.mobileLocalCodeGenerator.generate();
        return new PhoneNumber(this.country.getPhoneCode(), preCode, localCode, true);
    }
}

