/*
 * Decompiled with CFR 0.152.
 */
package org.databene.domain.address;

import org.databene.commons.Escalator;
import org.databene.commons.LoggerEscalator;
import org.databene.commons.NullSafeComparator;

public class PhoneNumber {
    private static final Escalator escalator = new LoggerEscalator();
    private String countryCode;
    private String areaCode;
    private String localNumber;
    private boolean mobile;

    public PhoneNumber() {
        this("", "", "");
    }

    public PhoneNumber(String countryCode, String cityCode, String localNumber) {
        this(countryCode, cityCode, localNumber, false);
    }

    public PhoneNumber(String countryCode, String cityCode, String localNumber, boolean mobile) {
        this.countryCode = countryCode;
        this.areaCode = cityCode;
        this.localNumber = localNumber;
        this.mobile = mobile;
    }

    public String getCountryCode() {
        return this.countryCode;
    }

    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    public String getAreaCode() {
        return this.areaCode;
    }

    public void setAreaCode(String cityCode) {
        this.areaCode = cityCode;
    }

    @Deprecated
    public String getCityCode() {
        escalator.escalate(this.getClass().getSimpleName() + ".getCityCode() is deprecated. " + "Use getAreaCode() instead", this.getClass(), null);
        return this.areaCode;
    }

    @Deprecated
    public void setCityCode(String areaCode) {
        escalator.escalate(this.getClass().getSimpleName() + ".setCityCode(String) is deprecated. " + "Use setAreaCode(String) instead", this.getClass(), null);
        this.areaCode = areaCode;
    }

    public String getLocalNumber() {
        return this.localNumber;
    }

    public void setLocalNumber(String localNumber) {
        this.localNumber = localNumber;
    }

    @Deprecated
    public String getLocalCode() {
        escalator.escalate(this.getClass().getSimpleName() + ".getLocalCode() is deprecated. " + "Use getLocalNumber() instead", this.getClass(), null);
        return this.localNumber;
    }

    @Deprecated
    public void setLocalCode(String localCode) {
        escalator.escalate(this.getClass().getSimpleName() + ".setLocalCode() is deprecated. " + "Use setLocalNumber() instead", this.getClass(), null);
        this.localNumber = localCode;
    }

    public boolean isMobile() {
        return this.mobile;
    }

    public void setMobile(boolean mobile) {
        this.mobile = mobile;
    }

    public String toString() {
        return "+" + this.countryCode + '-' + this.areaCode + '-' + this.localNumber;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.areaCode == null ? 0 : this.areaCode.hashCode());
        result = 31 * result + (this.countryCode == null ? 0 : this.countryCode.hashCode());
        result = 31 * result + (this.localNumber == null ? 0 : this.localNumber.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PhoneNumber that = (PhoneNumber)obj;
        if (!this.areaCode.equals(that.areaCode)) {
            return false;
        }
        if (!NullSafeComparator.equals((Object)this.countryCode, (Object)that.countryCode)) {
            return false;
        }
        return this.localNumber.equals(that.localNumber);
    }
}

