/*
 * Decompiled with CFR 0.152.
 */
package org.databene.domain.address;

import java.text.FieldPosition;
import java.text.Format;
import java.text.ParseException;
import java.text.ParsePosition;
import org.databene.domain.address.PhoneNumber;

public class PhoneNumberFormat
extends Format {
    private static final long serialVersionUID = -7235352934060711517L;
    private String pattern;

    public PhoneNumberFormat(String pattern) {
        this.pattern = pattern;
    }

    public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
        PhoneNumber number = (PhoneNumber)obj;
        block5: for (int i = 0; i < this.pattern.length(); ++i) {
            char c = this.pattern.charAt(i);
            switch (c) {
                case 'c': {
                    toAppendTo.append(number.getCountryCode());
                    continue block5;
                }
                case 'a': {
                    toAppendTo.append(number.getAreaCode());
                    continue block5;
                }
                case 'l': {
                    toAppendTo.append(number.getLocalNumber());
                    continue block5;
                }
                default: {
                    toAppendTo.append(c);
                }
            }
        }
        return toAppendTo;
    }

    public Object parseObject(String source, ParsePosition pos) {
        PhoneNumber number = new PhoneNumber();
        block5: for (int i = 0; i < this.pattern.length(); ++i) {
            char c = this.pattern.charAt(i);
            switch (c) {
                case 'c': {
                    number.setCountryCode(this.parseDigits(source, pos));
                    continue block5;
                }
                case 'a': {
                    number.setAreaCode(this.parseDigits(source, pos));
                    continue block5;
                }
                case 'l': {
                    number.setLocalNumber(this.parseDigits(source, pos));
                    continue block5;
                }
                default: {
                    if (source.charAt(pos.getIndex()) != c) {
                        throw new IllegalArgumentException("Pattern '" + this.pattern + "' is not matched by String: " + source);
                    }
                    pos.setIndex(pos.getIndex() + 1);
                }
            }
        }
        return number;
    }

    public Object parseObject(String source) throws ParseException {
        try {
            return super.parseObject(source);
        }
        catch (IllegalArgumentException e) {
            throw new ParseException(e.getMessage(), -1);
        }
    }

    private String parseDigits(String source, ParsePosition pos) {
        int start;
        char c;
        int end;
        if (pos.getIndex() >= source.length()) {
            throw new IllegalArgumentException("Text cannot be parsed unambiguously as phone number with pattern: " + this.pattern);
        }
        for (end = start = pos.getIndex(); end < source.length() && Character.isDigit(c = source.charAt(end)); ++end) {
        }
        pos.setIndex(end);
        return source.substring(start, end);
    }
}

