/*
 * Decompiled with CFR 0.152.
 */
package org.databene.domain.address;

import java.util.Collection;
import java.util.Map;
import org.databene.commons.NullSafeComparator;
import org.databene.commons.OrderedMap;
import org.databene.domain.address.City;
import org.databene.domain.address.CityId;
import org.databene.domain.address.Country;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class State {
    private String id;
    private String name;
    private Country country;
    private Map<CityId, City> cities;

    public State() {
        this(null);
    }

    public State(String id) {
        this.id = id;
        this.cities = new OrderedMap();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Country getCountry() {
        return this.country;
    }

    public void setCountry(Country country) {
        this.country = country;
    }

    public City getCity(CityId id) {
        return this.cities.get(id);
    }

    public Collection<City> getCities() {
        return this.cities.values();
    }

    public void addCity(CityId id, City city) {
        city.setState(this);
        this.cities.put(id, city);
    }

    public String toString() {
        return this.name != null ? this.name : this.id;
    }

    public int hashCode() {
        return NullSafeComparator.hashCode((Object)this.country) * 31 + this.name.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        State that = (State)obj;
        if (!NullSafeComparator.equals((Object)this.country, (Object)that.country)) {
            return false;
        }
        return this.name.equals(that.name);
    }
}

