/*
 * Decompiled with CFR 0.152.
 */
package org.databene.domain.address;

import java.util.ArrayList;
import java.util.Random;
import org.databene.domain.address.City;

public class Street {
    private City city;
    private String name;
    private int maxHouseNumber;
    private Random random;

    public Street(City city, String name) {
        this(city, name, 50);
    }

    public Street(City city, String name, int maxHouseNumber) {
        this.city = city;
        this.name = name;
        this.maxHouseNumber = maxHouseNumber;
        this.random = new Random();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getMaxHouseNumber() {
        return this.maxHouseNumber;
    }

    public void setMaxHouseNumber(int maxHouseNumber) {
        this.maxHouseNumber = maxHouseNumber;
    }

    public String[] generateHouseNumberWithZipCode() {
        ArrayList<String> zipCodes = new ArrayList<String>(this.city.getZipCodes());
        return new String[]{String.valueOf(this.random(1, this.maxHouseNumber)), (String)zipCodes.get(this.random(0, zipCodes.size() - 1))};
    }

    private int random(int min, int max) {
        return min + this.random.nextInt(max - min + 1);
    }
}

