/*
 * Decompiled with CFR 0.152.
 */
package org.databene.domain.finance;

import org.databene.benerator.Generator;
import org.databene.benerator.primitive.regex.RegexStringGenerator;
import org.databene.benerator.util.LightweightGenerator;
import org.databene.commons.LocaleUtil;
import org.databene.commons.StringUtil;
import org.databene.domain.address.Country;
import org.databene.domain.finance.Bank;
import org.databene.domain.finance.BankAccount;
import org.databene.domain.finance.BankGenerator;
import org.databene.domain.finance.IBANUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BankAccountGenerator
extends LightweightGenerator<BankAccount> {
    private Generator<Bank> bankGenerator = new BankGenerator();
    private Generator<String> accountNumberGenerator = new RegexStringGenerator("[0-9]{8}");
    private String countryCode;

    public BankAccountGenerator() {
        super(BankAccount.class);
        LocaleUtil.getFallbackLocale();
        this.countryCode = Country.getDefault().getIsoCode();
    }

    @Override
    public BankAccount generate() {
        Bank bank = this.bankGenerator.generate();
        String accountNumber = this.accountNumberGenerator.generate();
        String iban = this.createIban(bank, accountNumber);
        return new BankAccount(bank, accountNumber, iban);
    }

    private String createIban(Bank bank, String accountNumber) {
        StringBuilder builder = new StringBuilder(this.countryCode);
        builder.append("00");
        builder.append(bank.getBankCode());
        builder.append(StringUtil.padLeft((String)accountNumber, (int)10, (char)'0'));
        return IBANUtil.fixChecksum(builder.toString());
    }
}

