/*
 * Decompiled with CFR 0.152.
 */
package org.databene.domain.finance;

import org.databene.benerator.util.LightweightGenerator;
import org.databene.benerator.util.SimpleRandom;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreditCardNumberGenerator
extends LightweightGenerator<String> {
    public CreditCardNumberGenerator() {
        super(String.class);
    }

    @Override
    public String generate() {
        char[] digits = new char[16];
        digits[0] = 52;
        for (int i = 1; i < 15; ++i) {
            digits[i] = (char)(48 + SimpleRandom.randomInt(0, 9));
        }
        digits[15] = 48;
        int sum = this.luhnSum(digits);
        digits[15] = (char)(sum % 10 == 0 ? 48 : (char)(58 - sum % 10));
        return new String(digits);
    }

    private int luhnSum(char[] digits) {
        int sum = 0;
        int parity = digits.length % 2;
        for (int i = digits.length - 1; i >= 0; --i) {
            int digit = digits[i] - 48;
            if (i % 2 == parity) {
                digit *= 2;
            }
            sum += digit > 9 ? digit - 9 : digit;
        }
        return sum;
    }
}

