/*
 * Decompiled with CFR 0.152.
 */
package org.databene.domain.finance;

import org.databene.commons.Validator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreditCardNumberValidator
implements Validator<String> {
    public boolean valid(String number) {
        if (number == null || number.length() < 13 || number.length() > 16) {
            return false;
        }
        int sum = 0;
        byte[] digits = number.getBytes();
        int parity = digits.length % 2;
        for (int i = digits.length - 1; i >= 0; --i) {
            int digit = digits[i] - 48;
            if (i % 2 == parity) {
                digit *= 2;
            }
            sum += digit > 9 ? digit - 9 : digit;
        }
        return sum % 10 == 0;
    }
}

