/*
 * Decompiled with CFR 0.152.
 */
package org.databene.domain.finance;

import java.math.BigDecimal;
import org.databene.commons.StringUtil;

public class IBANUtil {
    private static final BigDecimal NINETYSEVEN = BigDecimal.valueOf(97L);

    public static int checksum(String iban) {
        String tmp = (iban.substring(4) + iban.substring(0, 4)).toUpperCase();
        StringBuffer digits = new StringBuffer();
        for (int i = 0; i < tmp.length(); ++i) {
            char c = tmp.charAt(i);
            if (c >= '0' && c <= '9') {
                digits.append(c);
                continue;
            }
            if (c >= 'A' && c <= 'Z') {
                int n = c - 65 + 10;
                digits.append((char)(48 + n / 10));
                digits.append((char)(48 + n % 10));
                continue;
            }
            return -1;
        }
        BigDecimal n = new BigDecimal(digits.toString());
        int remainder = n.remainder(NINETYSEVEN).intValue();
        return remainder;
    }

    public static String fixChecksum(String ibanTemplate) {
        int remainder = IBANUtil.checksum(ibanTemplate);
        String pp = StringUtil.padLeft((String)String.valueOf(98 - remainder), (int)2, (char)'0');
        return ibanTemplate.substring(0, 2) + pp + ibanTemplate.substring(4);
    }
}

