/*
 * Decompiled with CFR 0.152.
 */
package org.databene.domain.finance;

import org.databene.commons.Validator;
import org.databene.domain.address.CountryCode2Validator;
import org.databene.domain.finance.IBANUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IBANValidator
implements Validator<String> {
    private CountryCode2Validator countryCodeValidator = new CountryCode2Validator();

    public boolean valid(String iban) {
        if (iban == null || iban.length() < 15 || iban.length() > 32) {
            return false;
        }
        String countryCode = iban.substring(0, 2);
        if (!this.countryCodeValidator.valid(countryCode)) {
            return false;
        }
        int checksum = IBANUtil.checksum(iban);
        return checksum == 1;
    }
}

