/*
 * Decompiled with CFR 0.152.
 */
package org.databene.domain.net;

import java.io.IOException;
import org.databene.benerator.util.LightweightGenerator;
import org.databene.commons.ConfigurationError;
import org.databene.commons.Converter;
import org.databene.commons.StringUtil;
import org.databene.commons.converter.FixedSourceTypeConverter;
import org.databene.domain.address.Country;
import org.databene.domain.net.TopLevelDomainGenerator;
import org.databene.domain.organization.CompanyNameGenerator;
import org.databene.text.DelocalizingConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompanyDomainGenerator
extends LightweightGenerator<String> {
    private CompanyNameGenerator companyNameGenerator;
    private TopLevelDomainGenerator tldGenerator;
    private Converter<String, String> normalizer;

    public CompanyDomainGenerator() {
        this(Country.getDefault().getIsoCode());
    }

    public CompanyDomainGenerator(String datasetName) {
        super(String.class);
        this.companyNameGenerator = new CompanyNameGenerator(false, false, false, datasetName);
        this.tldGenerator = new TopLevelDomainGenerator();
        this.normalizer = new Normalizer();
    }

    public void setDataset(String datasetName) {
        this.companyNameGenerator.setDataset(datasetName);
    }

    @Override
    public String generate() {
        return (String)this.normalizer.convert((Object)this.companyNameGenerator.generate()) + '.' + (String)this.tldGenerator.generate();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Normalizer
    extends FixedSourceTypeConverter<String, String> {
        private DelocalizingConverter delocalizer;

        public Normalizer() {
            super(String.class, String.class);
            try {
                this.delocalizer = new DelocalizingConverter();
            }
            catch (IOException e) {
                throw new ConfigurationError((Throwable)e);
            }
        }

        public String convert(String sourceValue) {
            sourceValue = StringUtil.normalizeSpace((String)sourceValue);
            sourceValue = this.delocalizer.convert(sourceValue);
            sourceValue = sourceValue.replace(' ', '-');
            return sourceValue.toLowerCase();
        }
    }
}

