/*
 * Decompiled with CFR 0.152.
 */
package org.databene.domain.net;

import java.io.IOException;
import java.util.Locale;
import org.databene.benerator.Generator;
import org.databene.benerator.sample.SequencedSampleGenerator;
import org.databene.benerator.util.LightweightGenerator;
import org.databene.commons.ConfigurationError;
import org.databene.commons.Converter;
import org.databene.commons.LocaleUtil;
import org.databene.commons.converter.CaseConverter;
import org.databene.commons.converter.ConverterChain;
import org.databene.domain.address.Country;
import org.databene.domain.net.DomainGenerator;
import org.databene.domain.person.Person;
import org.databene.domain.person.PersonGenerator;
import org.databene.text.DelocalizingConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EMailAddressGenerator
extends LightweightGenerator<String> {
    private PersonGenerator personGenerator;
    private DomainGenerator domainGenerator;
    private CaseConverter caseConverter;
    private Converter<String, String> nameConverter;
    private Generator<Character> joinGenerator;

    public EMailAddressGenerator() {
        this(Country.getDefault().getIsoCode());
    }

    public EMailAddressGenerator(String dataset) {
        super(String.class);
        this.personGenerator = new PersonGenerator(dataset, LocaleUtil.getFallbackLocale());
        this.domainGenerator = new DomainGenerator(dataset);
        this.caseConverter = new CaseConverter(false);
        try {
            this.nameConverter = new ConverterChain(new Converter[]{new DelocalizingConverter(), this.caseConverter});
        }
        catch (IOException e) {
            throw new ConfigurationError("Error in Converter setup", (Throwable)e);
        }
        this.joinGenerator = new SequencedSampleGenerator<Character>(Character.class, Character.valueOf('_'), Character.valueOf('.'), Character.valueOf('0'), Character.valueOf('1'));
    }

    public String getDataset() {
        return this.personGenerator.getDataset();
    }

    public void setDataset(String datasetName) {
        this.personGenerator.setDataset(datasetName);
        this.domainGenerator.setDataset(datasetName);
    }

    public void setLocale(Locale locale) {
        this.personGenerator.setLocale(locale);
        this.caseConverter.setLocale(locale);
    }

    @Override
    public String generate() {
        Person person = this.personGenerator.generate();
        String given = (String)this.nameConverter.convert((Object)person.getGivenName());
        String family = (String)this.nameConverter.convert((Object)person.getFamilyName());
        String domain = (String)this.domainGenerator.generate();
        Character join = this.joinGenerator.generate();
        switch (join.charValue()) {
            case '.': {
                return given + '.' + family + '@' + domain;
            }
            case '_': {
                return given + '_' + family + '@' + domain;
            }
            case '0': {
                return given + family + '@' + domain;
            }
            case '1': {
                return given.charAt(0) + family + '@' + domain;
            }
        }
        throw new ConfigurationError("Invalid join strategy: " + join);
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

